/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UpsertBulkOperation
extends AbstractSalesforceOperationMigrationStep
implements ExpressionMigratorAware {
    private static final String m3Name = "upsert-bulk";
    private static final String m4Name = "create-job";

    public UpsertBulkOperation() {
        super(m4Name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)m3Name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        super.execute(mule3Operation, report);
        this.resolveAttributes(mule3Operation, this.mule4Operation);
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
        this.addCreateBatchElement(mule3Operation, this.mule4Operation);
    }

    private void resolveAttributes(Element mule3Operation, Element mule4Operation) {
        SalesforceUtils.resolveTypeAttribute(mule3Operation, mule4Operation);
        mule4Operation.setAttribute("operation", "upsert");
        String externalIdFieldName = mule3Operation.getAttributeValue("externalIdFieldName");
        StringBuilder requestContents = new StringBuilder();
        if (externalIdFieldName != null && !externalIdFieldName.isEmpty()) {
            requestContents.append("externalIdFieldName: \"" + externalIdFieldName + "\"");
        }
        if (requestContents != null && requestContents.length() != 0) {
            Element createJobRequest = new Element("create-job-request", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
            createJobRequest.setContent((Content)new CDATA("%dw 2.0 output application/java\n---\n{\n" + requestContents.toString() + "\n} as Object { class : \"org.mule.extension.salesforce.api.bulk.CreateJobRequest\" }"));
            mule4Operation.addContent((Content)createJobRequest);
        }
    }

    private void addCreateBatchElement(Element mule3Operation, Element mule4Operation) {
        Element createBatch = new Element("create-batch");
        createBatch.setName("create-batch");
        createBatch.setNamespace(SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
        createBatch.removeContent();
        createBatch.setAttribute("config-ref", mule4Operation.getAttributeValue("config-ref"));
        createBatch.setAttribute("jobInfoBatch", "#[payload]");
        Optional<Element> objects = Optional.ofNullable(mule3Operation.getChild("objects", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        objects.ifPresent(records -> {
            SalesforceUtils.migrateRecordsFromExpression(records, createBatch, this.expressionMigrator, "objects");
            List children = records.getChildren();
            if (children.size() > 0) {
                String objectsJSON = children.stream().map(object -> object.getChildren().stream().map(innerObject -> innerObject.getAttributeValue("key") + " : \"" + innerObject.getText() + "\"").collect(Collectors.joining(",\n"))).collect(Collectors.joining("\n},\n{"));
                Element m4Objects = new Element("objects", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
                m4Objects.setContent((Content)new CDATA("%dw 2.0 output application/json\n---\n[{\n" + objectsJSON + "\n}]"));
                createBatch.addContent((Content)m4Objects);
            }
        });
        XmlDslUtils.addElementAfter((Element)createBatch, (Element)mule4Operation);
    }
}

