/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.crc32;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collections;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Crc32Filter
extends AbstractFilterMigrator {
    private static final String CRC32_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/crc32";
    private static final Namespace CRC32_NAMESPACE = Namespace.getNamespace((String)"crc32", (String)"http://www.mulesoft.org/schema/mule/crc32");
    private static final Namespace CRYPTO_NAMESPACE = Namespace.getNamespace((String)"crypto", (String)"http://www.mulesoft.org/schema/mule/crypto");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/crc32' and local-name() = 'filter']";

    @Override
    public String getDescription() {
        return "Update crc32 filter to use the cryptography module.";
    }

    public Crc32Filter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(CRC32_NAMESPACE));
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Crc32Filter.addCryptoNamespace(element.getDocument());
        element.setName("validate-checksum");
        element.setNamespace(CRYPTO_NAMESPACE);
        element.removeAttribute("config-ref");
        element.setAttribute("algorithm", "CRC32");
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("expectedChecksum"), (ExpressionMigrator)this.getExpressionMigrator());
        element.getAttribute("expectedChecksum").setName("expected");
        this.handleFilter(element);
    }

    public static void addCryptoNamespace(Document document) {
        ApplicationModel.addNameSpace((Namespace)CRYPTO_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/crypto/current/mule-crypto.xsd", (Document)document);
    }
}

