/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.sftp;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.sftp.AbstractSftpEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.sftp.SftpConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;

public class SftpOutboundEndpoint
extends AbstractSftpEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'outbound-endpoint']";

    public String getDescription() {
        return "Update SFTP outbound endpoints.";
    }

    public SftpOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element flow;
        Element source;
        object.setName("write");
        object.setNamespace(SftpConfig.SFTP_NAMESPACE);
        String configName = object.getAttributeValue("connector-ref");
        Optional config = configName != null ? this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'config' and @name = '" + configName + "']") : this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'config']");
        Element sftpConfig = this.migrateSftpConfig(object, configName, config, report);
        Element connection = sftpConfig.getChild("connection", SftpConfig.SFTP_NAMESPACE);
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            connection.setAttribute("host", address.getHost());
            connection.setAttribute("port", address.getPort());
            if (address.getCredentials() != null) {
                String[] credsSplit = address.getCredentials().split(":");
                connection.setAttribute("username", credsSplit[0]);
                if (credsSplit.length > 1) {
                    connection.setAttribute("password", credsSplit[1]);
                }
            }
            object.setAttribute("path", address.getPath() != null ? this.resolveDirectory(address.getPath()) : "/");
        });
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user", (String)"username");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.setAttribute("config-ref", sftpConfig.getAttributeValue("name"));
        }
        object.removeAttribute("name");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"identityFile");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"passphrase");
        if (object.getAttribute("responseTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"responseTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        if (object.getAttribute("tempDir") != null) {
            report.report("sftp.tempDir", object, object, new String[0]);
            object.removeAttribute("tempDir");
        }
        if (object.getAttribute("duplicateHandling") != null) {
            String duplicateHandling = object.getAttributeValue("duplicateHandling");
            if ("throwException".equals(duplicateHandling)) {
                object.setAttribute("mode", "CREATE_NEW");
            } else if ("overwrite".equals(duplicateHandling)) {
                object.setAttribute("mode", "OVERWRITE");
            } else if ("append".equals(duplicateHandling)) {
                object.setAttribute("mode", "APPEND");
            } else if ("addSeqNo".equals(duplicateHandling)) {
                report.report("sftp.addSeqNo", object, object, new String[0]);
            }
            object.removeAttribute("duplicateHandling");
        }
        if ("false".equals(object.getAttributeValue("keepFileOnError")) && (source = (Element)(flow = XmlDslUtils.getContainerElement((Element)object)).getChildren().get(0)).getName().equals("listener") && source.getNamespace().equals((Object)SftpConfig.SFTP_NAMESPACE)) {
            Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement((Element)flow);
            if (errorHandler == null) {
                errorHandler = new Element("error-handler", XmlDslUtils.CORE_NAMESPACE);
                flow.addContent((Content)errorHandler);
            }
            errorHandler.addContent((Content)new Element("on-error-continue", XmlDslUtils.CORE_NAMESPACE).setAttribute("errorType", "SFTP:ILLEGAL_PATH,SFTP:ILLEGAL_CONTENT,SFTP:FILE_ALREADY_EXISTS,SFTP:ACCESS_DENIED").addContent((Content)new Element("outbound-properties-to-var", TransportsUtils.COMPATIBILITY_NAMESPACE)));
        }
        object.removeAttribute("keepFileOnError");
        if (object.getAttribute("knownHostsFile") != null && connection.getAttribute("knownHostsFile") == null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"knownHostsFile");
        }
        object.removeAttribute("knownHostsFile");
        TransportsUtils.extractInboundChildren((Element)object, (ApplicationModel)this.getApplicationModel());
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report);
        object.setAttribute("path", this.getExpressionMigrator().wrap((object.getAttribute("path") != null ? "'" + object.getAttributeValue("path") + "/' ++ " : "") + this.compatibilityOutputFile("{ outputPattern: " + this.propToDwExpr(object, "outputPattern") + ", outputPatternConfig: " + this.getExpressionMigrator().unwrap(this.propToDwExpr(object, "outputPatternConfig")) + "}")));
        object.removeAttribute("outputPattern");
        object.removeAttribute("outputPatternConfig");
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    private String compatibilityOutputFile(String pathDslParams) {
        try {
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(this.getApplicationModel().getProjectBasePath()), "SftpWriteOutputFile.dwl", "/**" + System.lineSeparator() + " * Emulates the outbound endpoint logic for determining the output filename of the Mule 3.x Sftp transport." + System.lineSeparator() + " */" + System.lineSeparator() + "fun sftpWriteOutputfile(vars: {}, pathDslParams: {}) = do {" + System.lineSeparator() + "    (((((pathDslParams.outputPattern" + System.lineSeparator() + "         default vars.compatibility_outboundProperties.outputPattern)" + System.lineSeparator() + "         default pathDslParams.outputPatternConfig)" + System.lineSeparator() + "         default vars.compatibility_outboundProperties.filename)" + System.lineSeparator() + "         default vars.filename)" + System.lineSeparator() + "         default vars.compatibility_inboundProperties.filename)" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "migration::SftpWriteOutputFile::sftpWriteOutputfile(vars, " + pathDslParams + ")";
    }

    private String propToDwExpr(Element object, String propName) {
        if (object.getAttribute(propName) != null) {
            if (this.getExpressionMigrator().isTemplate(object.getAttributeValue(propName))) {
                return this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(object.getAttributeValue(propName), true, object));
            }
            return "'" + object.getAttributeValue(propName) + "'";
        }
        return "null";
    }
}

