/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class SpringConfigInMuleConfig
extends AbstractSpringMigratorStep {
    public static final String XPATH_SELECTOR = "/*[starts-with(namespace-uri(), 'http://www.mulesoft.org/schema/mule/')]/*[namespace-uri()='http://www.springframework.org/schema/beans' and local-name()='beans']";

    public String getDescription() {
        return "Migrates the spring beans configuration form the mule config to its own file.";
    }

    public SpringConfigInMuleConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Document muleDocument = object.getDocument();
        Document springDocument = this.resolveSpringDocument(muleDocument);
        for (Element element : new ArrayList(object.getChildren())) {
            element.detach();
            springDocument.getRootElement().addContent((Content)element);
            this.moveNamespacesDeclarations(muleDocument, element, springDocument);
        }
        object.detach();
    }
}

