/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SpringContributions
extends AbstractSpringMigratorStep {
    public static final String ADDITIONAL_SPRING_NAMESPACES_PROP = "mule.migration.additionalSpringNamespaces";
    private static final String ADDITIONAL_SPRING_NAMESPACES = System.getProperty("mule.migration.additionalSpringNamespaces");
    public static final String XPATH_SELECTOR = "/*[starts-with(namespace-uri(), 'http://www.mulesoft.org/schema/mule/')]/*[starts-with(namespace-uri(), 'http://www.springframework.org/schema') %s]";

    public String getDescription() {
        return "Migrates the rest of spring elements.";
    }

    public SpringContributions() {
        if (ADDITIONAL_SPRING_NAMESPACES == null) {
            this.setAppliedTo(String.format(XPATH_SELECTOR, ""));
            this.setNamespacesContributions(Collections.singletonList(Namespace.getNamespace((String)"ss", (String)"http://www.springframework.org/schema/security")));
        } else {
            ArrayList<Namespace> additionalSpringNamespaces = new ArrayList<Namespace>();
            additionalSpringNamespaces.add(Namespace.getNamespace((String)"ss", (String)"http://www.springframework.org/schema/security"));
            additionalSpringNamespaces.addAll(Arrays.stream(ADDITIONAL_SPRING_NAMESPACES.split(",")).map(nsUri -> {
                String[] uriParts = nsUri.split("\\/");
                return Namespace.getNamespace((String)(uriParts[uriParts.length - 1] + "_" + RandomUtils.nextInt()), (String)nsUri);
            }).collect(Collectors.toList()));
            this.setAppliedTo(String.format(XPATH_SELECTOR, additionalSpringNamespaces.stream().map(ns -> "namespace-uri() = '" + ns.getURI() + "'").collect(Collectors.joining(" or ", "or ", ""))));
            this.setNamespacesContributions(additionalSpringNamespaces);
        }
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Document muleDocument = object.getDocument();
        Document springDocument = this.resolveSpringDocument(muleDocument);
        object.detach();
        springDocument.getRootElement().addContent((Content)object);
        this.moveNamespacesDeclarations(muleDocument, object, springDocument);
    }
}

