/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.version.VersionUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class SpringPropertiesPlaceholder
extends AbstractSpringMigratorStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.springframework.org/schema/context' and local-name()='property-placeholder']";

    public String getDescription() {
        return "Migrates the spring property placeholders.";
    }

    public SpringPropertiesPlaceholder() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        int idx = 1;
        Element elementToComment = null;
        for (String location : object.getAttributeValue("location").split("\\,")) {
            Element confProp = new Element("configuration-properties", XmlDslUtils.CORE_NAMESPACE);
            confProp.setAttribute("file", location);
            if (object.getAttribute("file-encoding") != null) {
                if (VersionUtils.isVersionGreaterOrEquals((String)this.getApplicationModel().getMuleVersion(), (String)"4.2.0").booleanValue()) {
                    confProp.setAttribute("encoding", object.getAttributeValue("file-encoding"));
                } else {
                    report.report("configProperties.encoding", object, object, new String[0]);
                }
            }
            object.getDocument().getRootElement().addContent(idx, (Content)confProp);
            if (elementToComment != null) continue;
            elementToComment = confProp;
        }
        if (object.getAttribute("order") != null) {
            report.report("configProperties.order", object, elementToComment, new String[0]);
        }
        if (object.getAttributeValue("properties-ref") != null || Boolean.parseBoolean(object.getAttributeValue("ignore-resource-not-found", "false")) || Boolean.parseBoolean(object.getAttributeValue("ignore-unresolvable", "false")) || Boolean.parseBoolean(object.getAttributeValue("local-override", "false")) || object.getAttributeValue("system-properties-mode") != null) {
            report.report("configProperties.springAttributes", object, elementToComment, new String[0]);
        }
        object.detach();
    }
}

