/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.wsc;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class WsConsumer
extends AbstractApplicationModelMigrationStep {
    private static final String WS_NAMESPACE_PREFIX = "ws";
    public static final String WS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/ws";
    public static final Namespace WS_NAMESPACE = Namespace.getNamespace((String)"ws", (String)"http://www.mulesoft.org/schema/mule/ws");
    private static final String WSC_NAMESPACE_PREFIX = "wsc";
    private static final String WSC_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/wsc";
    private static final Namespace WSC_NAMESPACE = Namespace.getNamespace((String)"wsc", (String)"http://www.mulesoft.org/schema/mule/wsc");
    public static final String XPATH_SELECTOR = "//ws:consumer";

    public String getDescription() {
        return "Update WebService consumer operation.";
    }

    public WsConsumer() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{WS_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element config;
        this.getApplicationModel().addNameSpace(WSC_NAMESPACE_PREFIX, WSC_NAMESPACE_URI, "http://www.mulesoft.org/schema/mule/wsc/current/mule-wsc.xsd");
        object.setNamespace(WSC_NAMESPACE);
        object.setName("consume");
        this.addAttributesToInboundProperties(object, report);
        if (object.getAttribute("config-ref") != null) {
            config = this.getApplicationModel().getNode("/*/wsc:config[@name='" + object.getAttributeValue("config-ref") + "']");
        } else {
            config = this.getApplicationModel().getNode("/*/wsc:config");
            object.setAttribute("config-ref", config.getAttributeValue("name"));
        }
        if (object.getAttribute("mtomEnabled") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)config.getChild("connection", WSC_NAMESPACE), (String)"mtomEnabled");
            object.removeAttribute("mtomEnabled");
        }
    }

    private void addAttributesToInboundProperties(Element object, MigrationReport report) {
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report);
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("http.headers", "message.attributes.protocolHeaders");
        try {
            InboundPropertiesHelper.addAttributesMapping(this.getApplicationModel(), "org.mule.runtime.extension.api.soap.SoapAttributes", expressionsPerProperty, "message.attributes.protocolHeaders");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

