/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Element;

public class MUnitConfig
extends AbstractApplicationModelMigrationStep {
    private static final String XPATH_SELECTOR = XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/munit", (String)"config", (boolean)true);
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_MOCK_CONNECTORS = "mock-connectors";
    private static final String ATTRIBUTE_MOCK_INBOUNDS = "mock-inbounds";

    public String getDescription() {
        return "Update MUnit config";
    }

    public MUnitConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            File munitFile = new File(element.getDocument().getBaseURI());
            ApplicationModelUtils.changeAttribute((String)ATTRIBUTE_NAME, Optional.empty(), Optional.of(FilenameUtils.getBaseName((String)munitFile.getName()))).apply(element);
        }
        catch (Exception e) {
            throw new MigrationStepException("Fail to apply step. " + e.getMessage());
        }
        if (element.getAttribute(ATTRIBUTE_MOCK_CONNECTORS) != null) {
            if (element.getAttributeValue(ATTRIBUTE_MOCK_CONNECTORS).equals("true")) {
                report.report("munit.mockConnectors", element, element.getParentElement(), new String[0]);
            }
            element.removeAttribute(ATTRIBUTE_MOCK_CONNECTORS);
        }
        if (element.getAttribute(ATTRIBUTE_MOCK_INBOUNDS) != null) {
            if (element.getAttributeValue(ATTRIBUTE_MOCK_INBOUNDS).equals("true")) {
                report.report("munit.mockInbounds", element, element.getParentElement(), new String[0]);
            }
            element.removeAttribute(ATTRIBUTE_MOCK_INBOUNDS);
        }
    }
}

