/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.steps;

import com.mulesoft.tools.migration.library.soapkit.helpers.DocumentHelper;
import com.mulesoft.tools.migration.library.soapkit.steps.AbstractSoapkitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Arrays;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class SoapkitFault
extends AbstractSoapkitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='fault' and namespace-uri()='http://www.mulesoft.org/schema/mule/apikit-soap']";

    public String getDescription() {
        return "Update APIkit for SOAP fault";
    }

    public SoapkitFault() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Arrays.asList(SOAPKIT_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) {
        DocumentHelper.replaceSlashesByBackSlashes(element, "config-ref");
        this.migrateFaultType(element, report);
    }

    private void migrateFaultType(Element element, MigrationReport report) {
        Attribute faultType = element.getAttribute("faultType");
        if (faultType != null) {
            String faultValue;
            String operationValue;
            String faultTypeValue = faultType.getValue();
            String[] split = faultTypeValue.split("\\|\\|");
            if (split.length <= 0) {
                throw new RuntimeException("Error parsing 'faultType' value");
            }
            if (split.length == 1) {
                report.report(MigrationReport.Level.WARN, element, element.getParentElement(), "Cannot find value for 'operation'", new String[0]);
                operationValue = "";
                faultValue = split[0];
            } else {
                if (split.length > 2) {
                    report.report(MigrationReport.Level.WARN, element, element.getParentElement(), "fault type shouldn't have more than two partes '<Operation>||<FaultType>'. Some data could be lost after migration", new String[0]);
                }
                operationValue = split[0];
                faultValue = split[1];
            }
            element.setAttribute("operation", operationValue);
            element.setAttribute("fault", faultValue);
            element.removeAttribute(faultType);
        }
    }
}

