/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.steps;

import com.mulesoft.tools.migration.library.soapkit.steps.AbstractSoapkitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Arrays;
import org.jdom2.Content;
import org.jdom2.Element;

public class SoapkitHttpListenerMapping
extends AbstractSoapkitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='router' and namespace-uri()='http://www.mulesoft.org/schema/mule/apikit-soap']";
    private static final String HTTP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/http";

    public String getDescription() {
        return "Update APIkit Http Listener Mappings";
    }

    public SoapkitHttpListenerMapping() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Arrays.asList(SOAPKIT_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element flow = SoapkitHttpListenerMapping.getParentFlow(element);
        if (flow != null) {
            Element httpListener = SoapkitHttpListenerMapping.getHttpListener(flow);
            this.migrateResponse(httpListener.getChild("response", httpListener.getNamespace()));
            this.migrateResponse(httpListener.getChild("error-response", httpListener.getNamespace()));
        }
    }

    private void migrateResponse(Element response) {
        this.migrateBodyMapping(response);
        this.migrateHeadersMapping(response);
    }

    private void migrateHeadersMapping(Element response) {
        Element header = response.getChild("headers", response.getNamespace());
        if (header == null) {
            header = new Element("headers", response.getNamespace());
            response.addContent((Content)header);
        }
        header.setText("#[attributes.protocolHeaders default {}]");
    }

    private void migrateBodyMapping(Element response) {
        Element header = response.getChild("body", response.getNamespace());
        if (header == null) {
            header = new Element("body", response.getNamespace());
            response.addContent(0, (Content)header);
        }
        header.setText("#[payload]");
    }

    private static boolean isHttpListener(Element element) {
        return HTTP_NAMESPACE_URI.equals(element.getNamespace().getURI()) && "listener".equalsIgnoreCase(element.getName());
    }

    private static Element getHttpListener(Element flow) {
        return flow.getChildren().stream().filter(SoapkitHttpListenerMapping::isHttpListener).findFirst().orElse(null);
    }

    private static Element getParentFlow(Element element) {
        if (XmlDslUtils.isTopLevelElement((Element)element)) {
            return null;
        }
        Element parent = element.getParentElement();
        if ("flow".equalsIgnoreCase(parent.getName())) {
            return parent;
        }
        return SoapkitHttpListenerMapping.getParentFlow(element);
    }
}

