/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step.util;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public final class ProjectStructureUtils {
    public static void renameFile(Path fileName, Path newFileName, ApplicationModel applicationModel, MigrationReport report) {
        File fileRename = fileName.toFile();
        if (fileRename.exists()) {
            fileRename.renameTo(newFileName.toFile());
            applicationModel.updateApplicationModelReference(fileName, newFileName);
            report.updateReportEntryFilePath(fileName, newFileName);
        }
    }

    public static void moveDirectory(File srcDir, File destDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!destDir.exists()) {
                FileUtils.moveDirectory((File)srcDir, (File)destDir);
            } else {
                FileUtils.copyDirectory((File)srcDir, (File)destDir);
                FileUtils.deleteDirectory((File)srcDir);
            }
        }
    }
}

