/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.task;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.step.MigrationStep;
import com.mulesoft.tools.migration.step.category.ApplicationModelContribution;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;
import com.mulesoft.tools.migration.step.category.PomContribution;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MigrationStepSelector {
    private List<MigrationStep> steps;

    public MigrationStepSelector(List<MigrationStep> steps) {
        Preconditions.checkArgument((steps != null ? 1 : 0) != 0, (Object)"The step list must not be null");
        this.steps = new ArrayList<MigrationStep>(steps);
    }

    public List<NamespaceContribution> getNameSpaceContributionSteps() {
        return this.filterAndCast(NamespaceContribution.class);
    }

    public List<ApplicationModelContribution> getApplicationModelContributionSteps() {
        return this.filterAndCast(ApplicationModelContribution.class);
    }

    public List<ProjectStructureContribution> getProjectStructureContributionSteps() {
        return this.filterAndCast(ProjectStructureContribution.class);
    }

    public List<PomContribution> getPomContributionSteps() {
        return this.filterAndCast(PomContribution.class);
    }

    private List<? extends MigrationStep> filterAndCast(Class<? extends MigrationStep> clazz) {
        return this.steps.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }
}

