/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project;

import com.mulesoft.tools.migration.engine.exception.MigrationJobException;
import com.mulesoft.tools.migration.engine.project.structure.mule.MuleProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeMavenApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeMavenDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreePolicy;
import com.mulesoft.tools.migration.project.ProjectType;
import java.nio.file.Path;

public class MuleProjectFactory {
    public static MuleProject getMuleProject(Path projectPath, ProjectType projectType) throws Exception {
        if (!projectType.equals((Object)ProjectType.BASIC) && !projectType.equals((Object)ProjectType.JAVA)) {
            if (projectType.equals((Object)ProjectType.MULE_THREE_APPLICATION)) {
                return new MuleThreeApplication(projectPath);
            }
            if (projectType.equals((Object)ProjectType.MULE_THREE_MAVEN_APPLICATION)) {
                return new MuleThreeMavenApplication(projectPath);
            }
            if (projectType.equals((Object)ProjectType.MULE_THREE_DOMAIN)) {
                return new MuleThreeDomain(projectPath);
            }
            if (projectType.equals((Object)ProjectType.MULE_THREE_MAVEN_DOMAIN)) {
                return new MuleThreeMavenDomain(projectPath);
            }
            if (projectType.equals((Object)ProjectType.MULE_THREE_POLICY)) {
                return new MuleThreePolicy(projectPath);
            }
        }
        throw new MigrationJobException("Cannot read mule project. Is it a Mule Studio project?");
    }
}

