/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report.html.model;

import com.mulesoft.tools.migration.engine.exception.MigrationJobException;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.located.LocatedElement;
import org.jdom2.located.LocatedJDOMFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.XMLOutputProcessor;
import org.jdom2.xpath.XPathFactory;

public class ReportEntryModel {
    private final MigrationReport.Level level;
    private final String key;
    private final String elementContent;
    private transient Element element;
    private Integer lineNumber = 0;
    private Integer columnNumber = 0;
    private final String message;
    private String filePath;
    private final List<String> documentationLinks = new ArrayList<String>();
    private static final XMLOutputProcessor noNamespaces = new AbstractXMLOutputProcessor(){

        protected void printNamespace(Writer out, FormatStack formatStack, Namespace ns) throws IOException {
        }
    };

    public ReportEntryModel(String key, MigrationReport.Level level, Element element, String message, String ... documentationLinks) {
        this.level = level;
        this.key = key;
        this.elementContent = element != null ? StringEscapeUtils.escapeXml11((String)this.domElementToString(element)) : "";
        this.element = element;
        this.message = message;
        if (element != null && element.getDocument() != null) {
            try {
                this.filePath = new File(new URI(element.getDocument().getBaseURI())).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Report Generation Error - Fail to get file: " + element.getDocument().getBaseURI(), e);
            }
        }
        this.documentationLinks.addAll(Arrays.asList(documentationLinks));
    }

    private ReportEntryModel(MigrationReport.Level level, Element element, String message, String ... documentationLinks) {
        this(null, level, element, message, documentationLinks);
    }

    private ReportEntryModel(MigrationReport.Level level, Element element, String message, Document document, String ... documentationLinks) {
        this(null, level, element, message, document, documentationLinks);
    }

    public ReportEntryModel(String key, MigrationReport.Level level, Element element, String message, Document document, String ... documentationLinks) {
        this(key, level, element, message, documentationLinks);
        try {
            this.filePath = new File(new URI(document.getBaseURI())).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Report Generation Error - Fail to get file: " + element.getDocument().getBaseURI(), e);
        }
    }

    public void setElementLocation() throws Exception {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setJDOMFactory((JDOMFactory)new LocatedJDOMFactory());
            if (this.filePath != null) {
                Document document = saxBuilder.build(Paths.get(this.filePath, new String[0]).toFile());
                this.setElementLocation(document);
            }
        }
        catch (Exception ex) {
            throw new MigrationJobException("Failed to obtain new element location.", ex);
        }
    }

    private void setElementLocation(Document document) {
        String xpathExpression = "";
        try {
            if (this.element == null || this.element.getDocument() == null) {
                this.lineNumber = -1;
                this.columnNumber = -1;
                return;
            }
            for (Element currentElement = this.element; currentElement != this.element.getDocument().getRootElement(); currentElement = currentElement.getParentElement()) {
                xpathExpression = "/*[" + (1 + currentElement.getParentElement().getChildren().indexOf(currentElement)) + "]" + xpathExpression;
            }
            xpathExpression = "/*" + xpathExpression;
            List elements = XPathFactory.instance().compile(xpathExpression, Filters.element()).evaluate((Object)document);
            if (elements.size() > 0) {
                this.lineNumber = ((LocatedElement)elements.get(0)).getLine();
                this.columnNumber = ((LocatedElement)elements.get(0)).getColumn();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Report Generation Error - Fail to set element location. Element name: " + this.element.getName() + ", xpath expression:" + xpathExpression, e);
        }
    }

    private String domElementToString(Element element) {
        Format format = Format.getPrettyFormat();
        format.setTextMode(Format.TextMode.NORMALIZE);
        format.setEncoding("UTF-8");
        format.setIndent("    ");
        XMLOutputter xmlOut = new XMLOutputter(noNamespaces);
        xmlOut.setFormat(format);
        return xmlOut.outputString(this.maskAttributesRecursively(element.clone()));
    }

    protected Element maskAttributesRecursively(Element element) {
        this.maskAttributes(element);
        element.getChildren().forEach(c -> {
            this.maskAttributes((Element)c);
            this.maskAttributesRecursively((Element)c);
        });
        return element;
    }

    protected void maskAttributes(Element element) {
        element.getAttributes().forEach(att -> {
            if (StringUtils.containsIgnoreCase((CharSequence)att.getName(), (CharSequence)"password") || StringUtils.containsIgnoreCase((CharSequence)att.getName(), (CharSequence)"secret")) {
                att.setValue("****");
            }
        });
    }

    public String getKey() {
        return this.key;
    }

    public MigrationReport.Level getLevel() {
        return this.level;
    }

    public String getElementContent() {
        return this.elementContent;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public Element getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public List<String> getDocumentationLinks() {
        return this.documentationLinks;
    }

    public int hashCode() {
        return Objects.hash(this.getLevel(), this.getElement(), this.getMessage(), this.getDocumentationLinks());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReportEntryModel that = (ReportEntryModel)obj;
        return Objects.equals(this.getLevel(), that.getLevel()) && Objects.equals(this.getElement(), that.getElement()) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getDocumentationLinks(), that.getDocumentationLinks());
    }
}

