/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.tools.migration.report.AbstractReport;
import com.mulesoft.tools.migration.report.DefaultMigrationReport;
import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.ComponentMigrationStatus;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jdom2.Element;

public class JSONReport
extends AbstractReport {
    private final Path outputProject;

    public JSONReport(MigrationReport<ReportEntryModel> report, File reportDirectory, Path outputProject) {
        super(report, reportDirectory);
        this.outputProject = outputProject;
    }

    public void printReport() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JSONReportModel jsonReportModel = new JSONReportModel((MigrationReport<ReportEntryModel>)this.report, this.outputProject);
        String json = gson.toJson((Object)jsonReportModel);
        File file = new File(this.reportDirectory, "report.json");
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            fileWriter.append(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class JSONReportEntryModel {
        private final MigrationReport.Level level;
        private final String key;
        private final String component;
        private final Integer lineNumber;
        private final Integer columnNumber;
        private final String message;
        private final String filePath;
        private final List<String> documentationLinks = new ArrayList<String>();

        private JSONReportEntryModel(String key, MigrationReport.Level level, Element component, Integer lineNumber, Integer columnNumber, String message, String filePath) {
            this.key = key;
            this.level = level;
            this.component = component != null ? DefaultMigrationReport.getComponentKeyStatic(component) : "UNKNOWN";
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.message = message;
            this.filePath = filePath;
        }

        public static JSONReportEntryModel fromReportModel(ReportEntryModel rem, Path outputFolder) {
            String filePath = JSONReportEntryModel.relativizePath(rem.getFilePath(), outputFolder);
            return new JSONReportEntryModel(rem.getKey(), rem.getLevel(), rem.getElement(), rem.getLineNumber(), rem.getColumnNumber(), rem.getMessage(), filePath);
        }

        private static String relativizePath(String filePath, Path basePath) {
            if (filePath == null) {
                return "";
            }
            Path path = new File(filePath).toPath();
            if (path.startsWith(basePath)) {
                return basePath.relativize(path).toString();
            }
            String parentDomainBasePath = System.getProperty("parentDomainBasePath");
            if (parentDomainBasePath != null && path.startsWith(parentDomainBasePath)) {
                return "{parentDomainBasePath}:/" + Paths.get(parentDomainBasePath, new String[0]).relativize(path);
            }
            return filePath;
        }

        public String getKey() {
            return this.key;
        }

        public MigrationReport.Level getLevel() {
            return this.level;
        }

        public String getComponent() {
            return this.component;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public Integer getColumnNumber() {
            return this.columnNumber;
        }

        public String getMessage() {
            return this.message;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public List<String> getDocumentationLinks() {
            return this.documentationLinks;
        }
    }

    static class JSONReportModel {
        private final String projectType;
        private final String projectName;
        private final List<String> connectorsMigrated;
        private final Integer numberOfMuleComponents;
        private final Integer numberOfMuleComponentsMigrated;
        private final Map<String, ComponentMigrationStatus> componentDetails;
        private final Integer numberOfMELExpressions;
        private final Integer numberOfMELExpressionsMigrated;
        private final Integer numberOfMELExpressionLines;
        private final Integer numberOfMELExpressionLinesMigrated;
        private final Integer numberOfDWTransformations;
        private final Integer numberOfDWTransformationsMigrated;
        private final Integer numberOfDWTransformationLines;
        private final Integer numberOfDWTransformationLinesMigrated;
        private final List<JSONReportEntryModel> detailedMessages;

        public JSONReportModel(MigrationReport<ReportEntryModel> report, Path outputProject) {
            this.projectType = report.getProjectType();
            this.projectName = report.getProjectName();
            this.connectorsMigrated = report.getConnectorNames();
            this.numberOfMuleComponentsMigrated = report.getComponentSuccessCount();
            this.numberOfMuleComponents = report.getComponentFailureCount() + this.numberOfMuleComponentsMigrated;
            this.componentDetails = report.getComponents();
            this.numberOfMELExpressionsMigrated = report.getMelExpressionsSuccessCount();
            this.numberOfMELExpressions = report.getMelExpressionsCount();
            this.numberOfMELExpressionLinesMigrated = report.getMelExpressionsSuccessLineCount();
            this.numberOfMELExpressionLines = report.getMelExpressionsLineCount();
            this.numberOfDWTransformationsMigrated = report.getDwTransformsSuccessCount();
            this.numberOfDWTransformations = report.getDwTransformsCount();
            this.numberOfDWTransformationLinesMigrated = report.getDwTransformsSuccessLineCount();
            this.numberOfDWTransformationLines = report.getDwTransformsLineCount();
            this.detailedMessages = report.getReportEntries().stream().map(re -> JSONReportEntryModel.fromReportModel(re, outputProject)).sorted(Comparator.comparing(JSONReportEntryModel::getMessage)).sorted(Comparator.comparing(JSONReportEntryModel::getColumnNumber)).sorted(Comparator.comparing(JSONReportEntryModel::getLineNumber)).collect(Collectors.toList());
        }

        public String getProjectType() {
            return this.projectType;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public List<String> getConnectorsMigrated() {
            return this.connectorsMigrated;
        }

        public Integer getNumberOfMuleComponents() {
            return this.numberOfMuleComponents;
        }

        public Integer getNumberOfMuleComponentsMigrated() {
            return this.numberOfMuleComponentsMigrated;
        }

        public Map<String, ComponentMigrationStatus> getComponentDetails() {
            return this.componentDetails;
        }

        public Integer getNumberOfMELExpressions() {
            return this.numberOfMELExpressions;
        }

        public Integer getNumberOfMELExpressionsMigrated() {
            return this.numberOfMELExpressionsMigrated;
        }

        public Integer getNumberOfMELExpressionLines() {
            return this.numberOfMELExpressionLines;
        }

        public Integer getNumberOfMELExpressionLinesMigrated() {
            return this.numberOfMELExpressionLinesMigrated;
        }

        public Integer getNumberOfDWTransformations() {
            return this.numberOfDWTransformations;
        }

        public Integer getNumberOfDWTransformationsMigrated() {
            return this.numberOfDWTransformationsMigrated;
        }

        public Integer getNumberOfDWTransformationLines() {
            return this.numberOfDWTransformationLines;
        }

        public Integer getNumberOfDWTransformationLinesMigrated() {
            return this.numberOfDWTransformationLinesMigrated;
        }

        public List<JSONReportEntryModel> getDetailedMessages() {
            return this.detailedMessages;
        }
    }
}

