/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.mulesoft.tools.migration.library.apikit.steps.AbstractApikitMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApikitErrorHandler
extends AbstractApikitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='mapping-exception-strategy' and namespace-uri()='http://www.mulesoft.org/schema/mule/mule-apikit']";

    public String getDescription() {
        return "Update APIkit Mapping Exception Strategy";
    }

    public ApikitErrorHandler() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        List mappings = element.getChildren("mapping", element.getNamespace());
        List errorMappings = mappings.stream().map(this::buildOnErrorFromApikitMapping).collect(Collectors.toList());
        element.removeChildren("mapping", element.getNamespace());
        element.addContent(errorMappings);
        ApplicationModelUtils.changeNodeName((String)"", (String)"error-handler").apply(element);
        this.migrateWhenExpression(element);
    }

    private Element buildOnErrorFromApikitMapping(Element mapping) {
        Namespace rootNamespace = mapping.getDocument().getRootElement().getNamespace();
        Element newOnError = new Element("on-error-propagate", rootNamespace);
        Element exception = mapping.getChild("exception", mapping.getNamespace());
        Attribute exceptionAttribute = exception.getAttribute("value");
        if (exceptionAttribute != null) {
            String exceptionClass = exceptionAttribute.getValue();
            String errorType = this.getErrorForException(exceptionClass);
            if (errorType != null) {
                newOnError.setAttribute("type", errorType);
            } else {
                newOnError.setAttribute("when", "#[mel:exception.causedBy(" + exceptionClass + ")]");
            }
        }
        String value = mapping.getAttributeValue("statusCode");
        Element httpStatusVariable = this.buildSetVariable("httpStatus", value, rootNamespace);
        newOnError.addContent((Content)httpStatusVariable);
        mapping.getChildren().stream().filter(e -> !e.getNamespace().equals((Object)mapping.getNamespace())).forEach(e -> newOnError.addContent((Content)e.clone()));
        return newOnError;
    }

    private Element buildSetVariable(String name, String value, Namespace rootNamespace) {
        Element httpStatusVariable = new Element("set-variable", rootNamespace);
        httpStatusVariable.setAttribute("variableName", name);
        httpStatusVariable.setAttribute("value", value);
        return httpStatusVariable;
    }

    private void migrateWhenExpression(Element element) {
        if (element.getAttribute("when") != null) {
            Attribute whenCondition = element.getAttribute("when");
            whenCondition.setValue(this.getExpressionMigrator().migrateExpression(whenCondition.getValue(), true, element));
        }
    }

    private String getErrorForException(String exceptionClass) {
        switch (exceptionClass) {
            case "org.mule.module.apikit.exception.BadRequestException": {
                return "APIKIT:BAD_REQUEST";
            }
            case "org.mule.module.apikit.exception.NotFoundException": {
                return "APIKIT:NOT_FOUND";
            }
            case "org.mule.module.apikit.exception.MethodNotAllowedException": {
                return "APIKIT:METHOD_NOT_ALLOWED";
            }
            case "org.mule.module.apikit.exception.NotAcceptableException": {
                return "APIKIT:NOT_ACCEPTABLE";
            }
            case "org.mule.module.apikit.exception.UnsupportedMediaTypeException": {
                return "APIKIT:UNSUPPORTED_MEDIA_TYPE";
            }
        }
        return null;
    }
}

