/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.basicstructure;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import com.mulesoft.tools.migration.step.util.ProjectStructureUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFileRenameMigrationStep
implements ProjectStructureContribution {
    private static Logger logger = LoggerFactory.getLogger(PolicyFileRenameMigrationStep.class);
    private static final Path SOURCE_FILE_PATH = Paths.get("src" + File.separator + "main" + File.separator + "mule", new String[0]);
    private static final String XML_EXTENSION = ".xml";
    private static final String YAML_EXTENSION = ".yaml";
    private static final String YML_EXTENSION = ".yml";
    private static final String TEMPLATE_FILENAME = "template.xml";
    private ApplicationModel applicationModel;

    public String getDescription() {
        return "Policy files rename step";
    }

    private Optional<File> getYamlFile(File projectBasePath) {
        return Arrays.stream(projectBasePath.listFiles((FilenameFilter)new SuffixFileFilter(new String[]{YAML_EXTENSION, YML_EXTENSION}))).findFirst();
    }

    private void treatYaml(File projectBasePath, File yamlFile, String xmlFilename, MigrationReport migrationReport) {
        Optional pomModel = this.applicationModel.getPomModel();
        if (pomModel.isPresent()) {
            File newYamlFile = new File(projectBasePath, ((PomModel)pomModel.get()).getArtifactId() + YAML_EXTENSION);
            if (!newYamlFile.exists() && !new File(projectBasePath, ((PomModel)pomModel.get()).getArtifactId() + YML_EXTENSION).exists()) {
                try {
                    Files.move(yamlFile.toPath(), newYamlFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    logger.debug(String.format("Failed to rename yaml file to", newYamlFile.getAbsolutePath()), (Throwable)e);
                    migrationReport.report("basicStructure.yamlRenameFailed", null, null, new String[0]);
                }
                logger.debug(String.format("Renamed yaml policy from %s to %s", yamlFile.getAbsolutePath(), newYamlFile.getAbsolutePath()));
            }
        } else {
            migrationReport.report("basicStructure.noPomModel", null, null, new String[]{xmlFilename});
        }
    }

    private void rename(File projectBasePath, File xmlFile, Path sourcesFilePath, MigrationReport migrationReport) {
        Optional<File> yamlFile = this.getYamlFile(projectBasePath);
        if (yamlFile.isPresent()) {
            this.treatYaml(projectBasePath, yamlFile.get(), xmlFile.getName(), migrationReport);
            ProjectStructureUtils.renameFile((Path)xmlFile.toPath(), (Path)sourcesFilePath.resolve(TEMPLATE_FILENAME), (ApplicationModel)this.applicationModel, (MigrationReport)migrationReport);
        } else {
            migrationReport.report("basicStructure.noYamlFound", null, null, new String[0]);
        }
    }

    public void execute(Path path, MigrationReport migrationReport) throws RuntimeException {
        Optional<File> policyTemplate;
        File projectBasePath = path.toFile();
        Path sourceFilesPath = path.resolve(SOURCE_FILE_PATH);
        if (sourceFilesPath.toFile().exists() && (policyTemplate = Arrays.stream(sourceFilesPath.toFile().listFiles((FilenameFilter)new SuffixFileFilter(XML_EXTENSION))).findFirst()).isPresent()) {
            this.rename(projectBasePath, policyTemplate.get(), sourceFilesPath, migrationReport);
        }
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }
}

