/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class ChoiceExpressions
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String XPATH_SELECTOR = "//mule:choice";
    private static final String WHEN_NODE_NAME = "when";
    private static final String EXPRESSION_ATTRIBUTE = "expression";
    private ExpressionMigrator expressionMigrator;

    public ChoiceExpressions() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public String getDescription() {
        return "Migrate Choice expressions.";
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        List whenNodes = element.getChildren(WHEN_NODE_NAME, element.getNamespace());
        whenNodes.forEach(this::migrateExpression);
    }

    private void migrateExpression(Element element) {
        Attribute expression = element.getAttribute(EXPRESSION_ATTRIBUTE);
        if (expression != null) {
            String migratedExpression = this.getExpressionMigrator().migrateExpression(expression.getValue(), true, element);
            migratedExpression = this.expressionMigrator.wrap(migratedExpression);
            expression.setValue(migratedExpression);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

