/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class Enricher
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String ATTACHMENT_ENRICHMENT_REGEX = "\\#\\[mel:message\\.outboundAttachments\\['([^']+)'\\] = new DataHandler\\(\\$, 'text\\/plain'\\)]";
    private static final Pattern ATTACHEMNT_ENRICHMENT_PATTERN = Pattern.compile("\\#\\[mel:message\\.outboundAttachments\\['([^']+)'\\] = new DataHandler\\(\\$, 'text\\/plain'\\)]");
    public static final String XPATH_SELECTOR = "//mule:enricher";
    private final Map<String, AtomicInteger> enricherSubFlowIndex = new HashMap<String, AtomicInteger>();
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Migrate enricher scope";
    }

    public Enricher() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element flow = XmlDslUtils.getContainerElement((Element)element);
        String subFlowName = this.getSubFlowName(flow);
        Element flowRef = new Element("flow-ref", XmlDslUtils.CORE_NAMESPACE).setAttribute("name", subFlowName);
        XmlDslUtils.addElementAfter((Element)flowRef, (Element)element);
        String target = element.getAttributeValue("target");
        String source = element.getAttributeValue("source");
        if (target == null && source == null) {
            Element firstEnrich = element.getChild("enrich", XmlDslUtils.CORE_NAMESPACE);
            target = firstEnrich.getAttributeValue("target");
            source = firstEnrich.getAttributeValue("source");
            firstEnrich.detach();
        }
        if (element.removeChildren("enrich", XmlDslUtils.CORE_NAMESPACE)) {
            report.report("enricher.multipleEnrichments", element, flowRef, new String[0]);
        }
        element.detach();
        Element subFlow = new Element("sub-flow", XmlDslUtils.CORE_NAMESPACE).setAttribute("name", subFlowName);
        if (element.getChild("processor-chain", XmlDslUtils.CORE_NAMESPACE) != null) {
            subFlow.addContent((Collection)element.getChild("processor-chain", XmlDslUtils.CORE_NAMESPACE).cloneContent());
        } else {
            subFlow.addContent((Collection)element.cloneContent());
        }
        if (flow != null) {
            XmlDslUtils.addElementAfter((Element)subFlow, (Element)flow);
        } else {
            XmlDslUtils.addTopLevelElement((Element)subFlow, (Document)flowRef.getDocument());
        }
        if (target != null) {
            String migratedTargetExpr = target.startsWith("#[message.outboundProperties.") ? StringUtils.substring((String)target, (int)"#[message.outboundProperties.".length(), (int)-1) : this.getExpressionMigrator().migrateExpression(target, true, flowRef, true);
            if (migratedTargetExpr.startsWith("#[vars.")) {
                migratedTargetExpr = StringUtils.substring((String)migratedTargetExpr, (int)"#[vars.".length(), (int)-1);
            } else if (migratedTargetExpr.matches(ATTACHMENT_ENRICHMENT_REGEX)) {
                Matcher matcher = ATTACHEMNT_ENRICHMENT_PATTERN.matcher(migratedTargetExpr);
                matcher.matches();
                migratedTargetExpr = matcher.group(1);
            } else {
                migratedTargetExpr = this.getExpressionMigrator().unwrap(migratedTargetExpr);
                XmlDslUtils.addCompatibilityNamespace((Document)flowRef.getDocument());
                XmlDslUtils.addElementAfter((Element)new Element("outbound-properties-to-var", TransportsUtils.COMPATIBILITY_NAMESPACE), (Element)flowRef);
                XmlDslUtils.addElementAfter((Element)new Element("set-property", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("propertyName", migratedTargetExpr).setAttribute("value", "#[vars." + migratedTargetExpr + "]"), (Element)flowRef);
                report.report("enricher.multipleEnrichments", element, flowRef, new String[0]);
            }
            flowRef.setAttribute("target", migratedTargetExpr);
        }
        if (source != null) {
            flowRef.setAttribute("targetValue", this.getExpressionMigrator().migrateExpression(source, true, flowRef));
        }
    }

    private String getSubFlowName(Element flow) {
        String flowName = "MMA_Top_Level";
        if (flow != null) {
            flowName = flow.getAttributeValue("name") != null ? flow.getAttributeValue("name") : flow.getParentElement().getName() + StringUtils.capitalize((String)flow.getName());
        }
        return flowName + "_Enricher_" + this.enricherSubFlowIndex.computeIfAbsent(flowName, k -> new AtomicInteger()).getAndIncrement();
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

