/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class KeepElementsAtBottomOfFlow
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//*[@*[namespace-uri() = 'migration' and local-name()='lastElement']]";
    public static final Namespace MIGRATION_NAMESPACE = Namespace.getNamespace((String)"migration");

    public String getDescription() {
        return "Ensure that the element will remain at the bottom of the flow.";
    }

    public KeepElementsAtBottomOfFlow() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        element.getAttributes().stream().filter(att -> att.getNamespace().equals((Object)MIGRATION_NAMESPACE) && att.getName().equals("lastElement")).collect(Collectors.toList()).forEach(att -> att.detach());
        element.removeNamespaceDeclaration(MIGRATION_NAMESPACE);
        Element flow = XmlDslUtils.getContainerElement((Element)element);
        element.detach();
        XmlDslUtils.addElementToBottom((Element)flow, (Content)element);
    }

    public boolean shouldReportMetrics() {
        return false;
    }
}

