/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.library.mule.steps.json.JsonMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;

public class RemoveJsonTransformerNamespace
implements NamespaceContribution {
    private static final String JSON_TRANSFORMER_XPRESSION = "//*[namespace-uri()='" + JsonMigrationStep.JSON_NAMESPACE.getURI() + "' and local-name()='json-to-object-transformer']";
    private static final String JSON_TRANSFORMER_SCHEMA = "http://www.mulesoft.org/schema/mule/json/current/mule-json.xsd";

    public String getDescription() {
        return "Remove Json to Object Namespace.";
    }

    public void execute(ApplicationModel applicationModel, MigrationReport report) throws RuntimeException {
        try {
            if (applicationModel.getNodes(JSON_TRANSFORMER_XPRESSION).isEmpty()) {
                applicationModel.removeNameSpace(JsonMigrationStep.JSON_NAMESPACE.getPrefix(), JsonMigrationStep.JSON_NAMESPACE.getURI(), JSON_TRANSFORMER_SCHEMA);
            }
        }
        catch (Exception e) {
            throw new MigrationStepException("Fail to apply step. " + e.getMessage());
        }
    }
}

