/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class IdempotentSecureHashMessageFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"idempotent-secure-hash-message-filter");

    @Override
    public String getDescription() {
        return "Update Idempotent SecureHash Message Filter to Idempotent-Message Validator.";
    }

    public IdempotentSecureHashMessageFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        String messageDigestAlgorithm = element.getAttributeValue("messageDigestAlgorithm");
        messageDigestAlgorithm = messageDigestAlgorithm == null ? "SHA-256" : messageDigestAlgorithm;
        element.removeAttribute("messageDigestAlgorithm");
        String idExpression = element.getAttributeValue("idExpression");
        idExpression = idExpression == null ? "correlationId" : this.getExpressionMigrator().unwrap(idExpression);
        element.setAttribute("idExpression", "%dw 2.0\n            output text/plain\n            import dw::Crypto\n            ---\n            Crypto::hashWith(" + idExpression + ", '" + messageDigestAlgorithm + "')");
        element.setName("idempotent-message-validator");
        this.handleFilter(element);
    }

    @Override
    protected Element resolveValidationHandler(Element errorHandler) {
        return errorHandler.getChildren().stream().filter(c -> "on-error-propagate".equals(c.getName()) && "DUPLICATE_MESSAGE".equals(c.getAttributeValue("type"))).findFirst().orElseGet(() -> {
            Element validationHandler = new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "DUPLICATE_MESSAGE").setAttribute("logException", "false");
            errorHandler.addContent(0, (Content)validationHandler);
            validationHandler.addContent((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", "filtered").setAttribute("value", "#[true]"));
            return validationHandler;
        });
    }
}

