/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.email;

import com.mulesoft.tools.migration.library.mule.steps.email.ImapInboundEndpoint;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ImapsInboundEndpoint
extends ImapInboundEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imaps' and local-name()='inbound-endpoint'][1]";

    @Override
    public String getDescription() {
        return "Update IMaps transport inbound endpoint.";
    }

    public ImapsInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Optional<Element> imapsConnector = object.getAttribute("connector-ref") != null ? Optional.of(this.getConnector(object.getAttributeValue("connector-ref"))) : this.getDefaultConnector();
        super.execute(object, report);
        Element imapsConnection = this.getApplicationModel().getNode("/*/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'imap-config' and @name = '" + object.getAttributeValue("config-ref") + "']/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'imaps-connection']");
        if (imapsConnector.isPresent() && imapsConnection.getChild("context", TLS_NAMESPACE) == null) {
            Element tlsClient;
            Element tlsContext = new Element("context", TLS_NAMESPACE);
            boolean tlsConfigured = false;
            Namespace imapsNamespace = Namespace.getNamespace((String)"imaps", (String)"http://www.mulesoft.org/schema/mule/imaps");
            Element tlsKeyStore = imapsConnector.get().getChild("tls-client", imapsNamespace);
            if (tlsKeyStore != null) {
                Element keyStore = new Element("key-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyPassword");
                if (tlsKeyStore.getAttribute("class") != null) {
                    report.report("email.imapKeyStoreClass", tlsKeyStore, tlsKeyStore, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyAlias", (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if ((tlsClient = imapsConnector.get().getChild("tls-trust-store", imapsNamespace)) != null) {
                Element keyStore = new Element("trust-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"storePassword", (String)"password");
                if (tlsClient.getAttribute("class") != null) {
                    report.report("email.imapTlsClientClass", tlsClient, tlsClient, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"type", (String)"type");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if (tlsConfigured) {
                this.getApplicationModel().addNameSpace(TLS_NAMESPACE.getPrefix(), TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
                imapsConnection.addContent((Content)tlsContext);
            }
        }
    }

    @Override
    protected Element createConnection() {
        return new Element("imaps-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnection(Element m4Config) {
        return m4Config.getChild("imaps-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imaps' and (local-name()='connector' or local-name()='gmail-connector') and @name = '" + connectorName + "']");
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/imaps' and (local-name()='connector' or local-name()='gmail-connector')]");
    }
}

