/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.endpoint;

import com.mulesoft.tools.migration.library.mule.steps.jms.AbstractJmsEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.jms.JmsOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.AbstractVmEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.VmOutboundEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.AbstractGlobalEndpointMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RequestReply
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//mule:request-reply";

    public String getDescription() {
        return "Migrate request-reply.";
    }

    public RequestReply() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element request = (Element)object.getChildren().get(0);
        Element reply = (Element)object.getChildren().get(1);
        if (object.getAttribute("storePrefix") != null) {
            report.report("transports.requestReplyStorePrefix", object, request, new String[0]);
            object.removeAttribute("storePrefix");
        }
        if (RequestReplyMigrableConnector.JMS.equals((Object)this.resolveEndpointConnector(request)) && RequestReplyMigrableConnector.JMS.equals((Object)this.resolveEndpointConnector(reply))) {
            this.handleGlobalEndpointsRefs(request, reply);
            Optional<Element> requestConnector = AbstractJmsEndpoint.resolveJmsConnector(request, this.getApplicationModel());
            Optional<Element> replyConnector = AbstractJmsEndpoint.resolveJmsConnector(reply, this.getApplicationModel());
            if (!requestConnector.equals(replyConnector)) {
                this.restoreConnectorRef(request, reply, requestConnector, replyConnector);
                String destination = TransportsUtils.processAddress((Element)reply, (MigrationReport)report).map(address -> {
                    String path = address.getPath();
                    if ("topic".equals(path)) {
                        return "TOPIC:" + address.getPort();
                    }
                    return path;
                }).orElseGet(() -> {
                    if (reply.getAttributeValue("queue") != null) {
                        return reply.getAttributeValue("queue");
                    }
                    return "TOPIC:" + reply.getAttributeValue("topic");
                });
                request.setAttribute("reply-to", destination, Namespace.getNamespace((String)"migration", (String)"migration"));
                this.migrateToReplyFlow(object, report, request, reply);
                return;
            }
            this.migrateJmsRequestReply(object, report, request, reply, requestConnector);
        } else if (RequestReplyMigrableConnector.VM.equals((Object)this.resolveEndpointConnector(request)) && RequestReplyMigrableConnector.VM.equals((Object)this.resolveEndpointConnector(reply))) {
            this.handleGlobalEndpointsRefs(request, reply);
            Optional<Element> requestConnector = AbstractVmEndpoint.resolveVmConector(request, this.getApplicationModel());
            Optional<Element> replyConnector = AbstractVmEndpoint.resolveVmConector(reply, this.getApplicationModel());
            if (!requestConnector.equals(replyConnector)) {
                this.restoreConnectorRef(request, reply, requestConnector, replyConnector);
                this.migrateToReplyFlow(object, report, request, reply);
                return;
            }
            this.migrateVmRequestReply(object, report, request, reply, requestConnector);
        } else {
            this.migrateToReplyFlow(object, report, request, reply);
        }
    }

    protected void restoreConnectorRef(Element request, Element reply, Optional<Element> requestConnector, Optional<Element> replyConnector) {
        requestConnector.ifPresent(c -> request.setAttribute("connector-ref", c.getAttributeValue("name")));
        replyConnector.ifPresent(c -> reply.setAttribute("connector-ref", c.getAttributeValue("name")));
    }

    protected void handleGlobalEndpointsRefs(Element request, Element reply) {
        Element globalEndpoint;
        if (request.getAttribute("ref") != null) {
            globalEndpoint = this.getApplicationModel().getNode("/*/*[@name = '" + request.getAttributeValue("ref") + "']");
            AbstractGlobalEndpointMigratorStep.copyAttributes((Element)globalEndpoint, (Element)request);
            request.removeAttribute("ref");
        }
        if (reply.getAttribute("ref") != null) {
            globalEndpoint = this.getApplicationModel().getNode("/*/*[@name = '" + reply.getAttributeValue("ref") + "']");
            AbstractGlobalEndpointMigratorStep.copyAttributes((Element)globalEndpoint, (Element)reply);
            reply.removeAttribute("ref");
        }
    }

    protected void migrateJmsRequestReply(Element object, MigrationReport report, Element request, Element reply, Optional<Element> requestConnector) {
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)AbstractJmsEndpoint.JMS_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/jms/current/mule-jms.xsd", (Document)object.getDocument());
        request.setNamespace(AbstractJmsEndpoint.JMS_NAMESPACE);
        request.setName("publish-consume");
        String jmsConfig = AbstractJmsEndpoint.migrateJmsConfig(request, report, requestConnector, this.getApplicationModel());
        JmsOutboundEndpoint.migrateOutboundJmsEndpoint(request, report, requestConnector, jmsConfig, this.getApplicationModel());
        request.detach();
        XmlDslUtils.addElementAfter((Element)request, (Element)object);
        object.detach();
        Element replyTo = request.getChild("message", AbstractJmsEndpoint.JMS_NAMESPACE).getChild("reply-to", AbstractJmsEndpoint.JMS_NAMESPACE);
        String destination = TransportsUtils.processAddress((Element)reply, (MigrationReport)report).map(address -> {
            String path = address.getPath();
            if ("topic".equals(path)) {
                replyTo.setAttribute("destinationType", "TOPIC");
                return address.getPort();
            }
            return path;
        }).orElseGet(() -> {
            if (reply.getAttributeValue("queue") != null) {
                return reply.getAttributeValue("queue");
            }
            replyTo.setAttribute("destinationType", "TOPIC");
            return reply.getAttributeValue("topic");
        });
        replyTo.setAttribute("destination", destination);
        if (object.getAttribute("timeout") != null) {
            request.addContent((Content)new Element("consume-configuration", AbstractJmsEndpoint.JMS_NAMESPACE).setAttribute("maximumWait", object.getAttributeValue("timeout")));
        }
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)request, (MigrationReport)report, (boolean)true);
        TransportsUtils.extractInboundChildren((Element)reply, (int)(request.getParentElement().indexOf((Content)request) + 2), (Element)request.getParentElement(), (ApplicationModel)this.getApplicationModel());
        AbstractJmsEndpoint.addAttributesToInboundProperties(request, this.getApplicationModel(), report);
    }

    protected void migrateVmRequestReply(Element object, MigrationReport report, Element request, Element reply, Optional<Element> requestConnector) {
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)AbstractVmEndpoint.VM_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd", (Document)object.getDocument());
        request.setNamespace(AbstractVmEndpoint.VM_NAMESPACE);
        request.setName("publish-consume");
        report.report("vm.requestReplyInbound", reply, request, new String[0]);
        String configName = AbstractVmEndpoint.getVmConfigName(object, requestConnector);
        Element vmConfig = AbstractVmEndpoint.migrateVmConfig(object, requestConnector, configName, this.getApplicationModel());
        VmOutboundEndpoint.migrateOutboundVmEndpoint(request, report, requestConnector, configName, vmConfig);
        request.detach();
        XmlDslUtils.addElementAfter((Element)request, (Element)object);
        object.detach();
        if (object.getAttribute("timeout") != null) {
            request.setAttribute("timeout", object.getAttributeValue("timeout"));
            request.setAttribute("timeoutUnit", "MILLISECONDS");
            object.removeAttribute("timeout");
        }
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)request, (MigrationReport)report, (boolean)true, (boolean)true);
        TransportsUtils.extractInboundChildren((Element)reply, (int)(request.getParentElement().indexOf((Content)request) + 2), (Element)request.getParentElement(), (ApplicationModel)this.getApplicationModel());
    }

    protected void migrateToReplyFlow(Element object, MigrationReport report, Element request, Element reply) {
        Element flow = XmlDslUtils.getContainerElement((Element)object);
        Element replyFlow = new Element("flow", XmlDslUtils.CORE_NAMESPACE);
        replyFlow.setAttribute("name", flow.getName() + "_reply");
        XmlDslUtils.addElementAfter((Element)replyFlow, (Element)flow);
        report.report("transports.requestReplySplit", object, request, new String[0]);
        request.detach();
        XmlDslUtils.addElementAfter((Element)request, (Element)object);
        object.detach();
        reply.detach();
        replyFlow.addContent((Content)reply);
        Element rrParent = request.getParentElement();
        while (rrParent.getContentSize() > rrParent.indexOf((Content)request) + 1) {
            Content content = (Content)rrParent.getContent().get(rrParent.indexOf((Content)request) + 1);
            content.detach();
            replyFlow.addContent(content);
        }
    }

    private RequestReplyMigrableConnector resolveEndpointConnector(Element endpoint) {
        if (AbstractVmEndpoint.VM_NAMESPACE.equals((Object)endpoint.getNamespace())) {
            return RequestReplyMigrableConnector.VM;
        }
        if (AbstractJmsEndpoint.JMS_NAMESPACE.equals((Object)endpoint.getNamespace())) {
            return RequestReplyMigrableConnector.JMS;
        }
        if (endpoint.getAttribute("address") != null) {
            String address = endpoint.getAttributeValue("address");
            if (address.startsWith("vm://")) {
                return RequestReplyMigrableConnector.VM;
            }
            if (address.startsWith("jms://")) {
                return RequestReplyMigrableConnector.JMS;
            }
        }
        if (endpoint.getAttribute("ref") != null) {
            Element globalEndpoint = this.getApplicationModel().getNode("/*/*[@name = '" + endpoint.getAttributeValue("ref") + "']");
            return this.resolveEndpointConnector(globalEndpoint);
        }
        return RequestReplyMigrableConnector.OTHER;
    }

    private static enum RequestReplyMigrableConnector {
        JMS,
        VM,
        OTHER;

    }
}

