/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.file;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Element;

public class FileTransformers
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and (local-name()='file-to-string-transformer' or local-name()='file-to-byte-array-transformer')]";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update File transformers.";
    }

    public FileTransformers() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        if (object.getAttribute("name") != null) {
            this.getApplicationModel().getNodes("//mule:transformer[@ref = '" + object.getAttributeValue("name") + "']").forEach(t -> t.detach());
        }
        report.report("file.notNeeded", object, object.getParentElement(), new String[]{object.getName()});
        object.detach();
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

