/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ftp;

import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractFtpEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    protected static final String FTP_NS_PREFIX = "ftp";
    protected static final String FTP_NS_URI = "http://www.mulesoft.org/schema/mule/ftp";
    private ExpressionMigrator expressionMigrator;

    protected Element migrateFtpConfig(Element object, Optional<Element> m3Config, String configName, Optional<Element> config, MigrationReport report) {
        Element ftpConfig = config.orElseGet(() -> {
            Element ftpCfg = new Element("config", FtpConfig.FTP_NAMESPACE);
            ftpCfg.setAttribute("name", configName != null ? configName : (object.getAttributeValue("name") != null ? object.getAttributeValue("name") : XmlDslUtils.getContainerElement((Element)object).getAttributeValue("name") + "Ftp") + "Config");
            Element conn = new Element("connection", FtpConfig.FTP_NAMESPACE);
            XmlDslUtils.migrateReconnection((Element)conn, (Element)object, (MigrationReport)report);
            ftpCfg.addContent((Content)conn);
            XmlDslUtils.addTopLevelElement((Element)ftpCfg, (Document)object.getDocument());
            return ftpCfg;
        });
        return ftpConfig;
    }

    protected String resolveDirectory(String endpointPath) {
        if (endpointPath.equals("/~")) {
            return "~";
        }
        if (endpointPath.startsWith("/~/")) {
            return StringUtils.substring((String)endpointPath, (int)3);
        }
        if (endpointPath.startsWith("/")) {
            return StringUtils.substring((String)endpointPath, (int)1);
        }
        return endpointPath;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

