/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ftp;

import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.library.mule.steps.file.FileInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.ftp.AbstractFtpEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.OptionalInt;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class FtpInboundEndpoint
extends AbstractFtpEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'inbound-endpoint'][1]";

    public String getDescription() {
        return "Update FTP inbound endpoints.";
    }

    public FtpInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("listener");
        object.setNamespace(FtpConfig.FTP_NAMESPACE);
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        String configName = object.getAttributeValue("connector-ref");
        Optional config = configName != null ? this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'config' and @name = '" + configName + "']") : this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'config']");
        Element ftpConfig = this.migrateFtpConfig(object, config, configName, config, report);
        Element connection = ftpConfig.getChild("connection", FtpConfig.FTP_NAMESPACE);
        this.addAttributesToInboundProperties(object, report);
        Element redelivery = object.getChild("idempotent-redelivery-policy", XmlDslUtils.CORE_NAMESPACE);
        if (redelivery != null) {
            redelivery.setName("redelivery-policy");
            Attribute exprAttr = redelivery.getAttribute("idExpression");
            if (exprAttr != null) {
                exprAttr.setValue(exprAttr.getValue().replaceAll("#\\[header\\:inbound\\:originalFilename\\]", "#[attributes.name]"));
                if (this.getExpressionMigrator().isWrapped(exprAttr.getValue())) {
                    exprAttr.setValue(this.getExpressionMigrator().wrap(this.getExpressionMigrator().migrateExpression(exprAttr.getValue(), true, object)));
                }
            }
            XmlDslUtils.migrateRedeliveryPolicyChildren((Element)redelivery, (MigrationReport)report);
        }
        TransportsUtils.migrateSchedulingStrategy((Element)object, (OptionalInt)OptionalInt.of(1000));
        this.doExecute(object, report);
        FileInboundEndpoint.migrateFileFilters(object, report, FtpConfig.FTP_NAMESPACE, this.getApplicationModel());
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            connection.setAttribute("host", address.getHost());
            connection.setAttribute("port", address.getPort());
            if (address.getCredentials() != null) {
                String[] credsSplit = address.getCredentials().split(":");
                connection.setAttribute("username", credsSplit[0]);
                connection.setAttribute("password", credsSplit[1]);
            }
            object.setAttribute("directory", address.getPath() != null ? address.getPath() : "/");
        });
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user", (String)"username");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        if (object.getAttribute("path") != null) {
            object.getAttribute("path").setName("directory");
        }
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.setAttribute("config-ref", ftpConfig.getAttributeValue("name"));
        }
        object.removeAttribute("name");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"passive");
        if (object.getAttribute("binary") != null) {
            connection.setAttribute("transferMode", "true".equals(object.getAttributeValue("binary")) ? "BINARY" : "ASCII");
            object.removeAttribute("binary");
        }
        if (object.getAttribute("encoding") != null) {
            object.getParent().addContent(3, (Content)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[payload]").setAttribute("encoding", object.getAttributeValue("encoding")));
            object.removeAttribute("encoding");
        }
        if (object.getAttribute("responseTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"responseTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    protected Optional<Element> fetchConfig(String configName) {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'config']");
    }

    protected void doExecute(Element object, MigrationReport report) {
    }

    private void addAttributesToInboundProperties(Element object, MigrationReport report) {
        TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("originalFilename", "message.attributes.name");
        expressionsPerProperty.put("fileSize", "message.attributes.size");
        expressionsPerProperty.put("timestamp", "message.attributes.timestamp");
        try {
            InboundPropertiesHelper.addAttributesMapping(this.getApplicationModel(), "org.mule.extension.ftp.api.ftp.FtpFileAttributes", expressionsPerProperty, new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

