/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.jms;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.jms.AbstractJmsEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class JmsOutboundEndpoint
extends AbstractJmsEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and local-name()='outbound-endpoint']";

    public String getDescription() {
        return "Update JMS transport outbound endpoint.";
    }

    public JmsOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{JMS_NAMESPACE}));
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("NONE".equals(action)) {
            return "NOT_SUPPORTED";
        }
        if ("ALWAYS_BEGIN".equals(action)) {
            report.report("jms.nestedTx", tx, object, new String[0]);
            return "ALWAYS_JOIN";
        }
        if ("BEGIN_OR_JOIN".equals(action)) {
            return "JOIN_IF_POSSIBLE";
        }
        return action;
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        JmsOutboundEndpoint.jmsTransportLib(this.getApplicationModel());
        Element tx = object.getChild("transaction", JMS_NAMESPACE);
        while (tx != null) {
            object.setAttribute("transactionalAction", this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object));
            object.removeChild("transaction", JMS_NAMESPACE);
            tx = object.getChild("transaction", JMS_NAMESPACE);
        }
        while (object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE) != null) {
            Element xaTx = object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(xaTx.getAttributeValue("action"), report, xaTx, object));
            object.removeChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
        }
        while (object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE) != null) {
            Element multiTx = object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(multiTx.getAttributeValue("action"), report, multiTx, object));
            object.removeChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
        }
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)JMS_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/jms/current/mule-jms.xsd", (Document)object.getDocument());
        object.setNamespace(JMS_NAMESPACE);
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("one-way")) {
            object.setName("publish");
        } else {
            Element wrappingTry = new Element("try", XmlDslUtils.CORE_NAMESPACE);
            object.getParentElement().addContent(object.getParentElement().indexOf((Content)object), (Content)wrappingTry);
            object.detach();
            wrappingTry.addContent((Content)object);
            wrappingTry.addContent((Content)new Element("error-handler", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("on-error-continue", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "JMS:TIMEOUT").addContent((Content)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[null]"))));
            object.setName("publish-consume");
        }
        Optional<Element> connector = JmsOutboundEndpoint.resolveJmsConnector(object, this.getApplicationModel());
        String configName = JmsOutboundEndpoint.migrateJmsConfig(object, report, connector, this.getApplicationModel());
        JmsOutboundEndpoint.migrateOutboundJmsEndpoint(object, report, connector, configName, this.getApplicationModel());
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        JmsOutboundEndpoint.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
    }

    public static void migrateOutboundJmsEndpoint(Element object, MigrationReport report, Optional<Element> connector, String configName, ApplicationModel appModel) {
        String destination = TransportsUtils.processAddress((Element)object, (MigrationReport)report).map(address -> {
            String path = address.getPath();
            if ("topic".equals(path)) {
                JmsOutboundEndpoint.configureTopicPublisher(object);
                return address.getPort();
            }
            return path;
        }).orElseGet(() -> {
            if (object.getAttributeValue("queue") != null) {
                return object.getAttributeValue("queue");
            }
            JmsOutboundEndpoint.configureTopicPublisher(object);
            return object.getAttributeValue("topic");
        });
        report.report("jms.propertiesPublish", object, object, new String[0]);
        Element outboundBuilder = new Element("message", JMS_NAMESPACE);
        Attribute migrationReplyTo = object.getAttribute("reply-to", Namespace.getNamespace((String)"migration", (String)"migration"));
        if (migrationReplyTo != null) {
            if (migrationReplyTo.getValue().startsWith("TOPIC:")) {
                outboundBuilder.addContent((Content)new Element("reply-to", JMS_NAMESPACE).setAttribute("destination", migrationReplyTo.getValue()).setAttribute("destinationType", "TOPIC"));
            } else {
                outboundBuilder.addContent((Content)new Element("reply-to", JMS_NAMESPACE).setAttribute("destination", migrationReplyTo.getValue()));
            }
            migrationReplyTo.detach();
        } else {
            outboundBuilder.addContent((Content)new Element("reply-to", JMS_NAMESPACE).setAttribute("destination", "#[migration::JmsTransport::jmsPublishReplyTo(vars)]"));
        }
        outboundBuilder.addContent((Content)JmsOutboundEndpoint.compatibilityProperties(appModel));
        outboundBuilder.setAttribute("correlationId", "#[migration::JmsTransport::jmsCorrelationId(correlationId, vars)]");
        object.setAttribute("sendCorrelationId", "#[migration::JmsTransport::jmsSendCorrelationId(vars)]");
        object.addContent((Content)outboundBuilder);
        connector.ifPresent(m3c -> {
            if (m3c.getAttributeValue("persistentDelivery") != null) {
                object.setAttribute("persistentDelivery", m3c.getAttributeValue("persistentDelivery"));
            }
            if ("true".equals(m3c.getAttributeValue("honorQosHeaders"))) {
                report.report("jms.inboundProperties", m3c, object, new String[0]);
                String defaultDeliveryMode = "true".equals(m3c.getAttributeValue("persistentDelivery")) ? "2" : "1";
                object.setAttribute("persistentDelivery", "#[(vars.compatibility_inboundProperties.JMSDeliveryMode default " + defaultDeliveryMode + ") == 2]");
                object.setAttribute("priority", "#[vars.compatibility_inboundProperties.JMSPriority default 4]");
            }
            TransportsUtils.handleConnectorChildElements((Element)m3c, (Element)appModel.getNode("*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and local-name()='config' and @name='" + configName + "']"), (Element)new Element("connection", XmlDslUtils.CORE_NAMESPACE), (MigrationReport)report);
        });
        if (object.getAttribute("responseTimeout") != null) {
            object.addContent((Content)new Element("consume-configuration", JMS_NAMESPACE).setAttribute("maximumWait", object.getAttributeValue("responseTimeout")));
        }
        object.removeAttribute("responseTimeout");
        object.setAttribute("config-ref", configName);
        if (destination != null) {
            object.setAttribute("destination", destination);
        }
        object.removeAttribute("queue");
        object.removeAttribute("topic");
        object.removeAttribute("name");
        object.removeAttribute("exchange-pattern");
    }

    private static void configureTopicPublisher(Element object) {
        object.setAttribute("destinationType", "TOPIC");
    }
}

