/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Collections;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ByIpRegexFilter
extends AbstractFilterMigrator {
    private static final String FILTERS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/filters";
    private static final Namespace FILTERS_NAMESPACE = Namespace.getNamespace((String)"filters", (String)"http://www.mulesoft.org/schema/mule/filters");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/filters' and local-name() = 'filter-by-ip']";

    @Override
    public String getDescription() {
        return "Update filter-by-ip filter to use the validations module.";
    }

    public ByIpRegexFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(FILTERS_NAMESPACE));
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ByIpRegexFilter.addValidationNamespace(element.getDocument());
        ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
        element.setName("matches-regex");
        element.setNamespace(VALIDATION_NAMESPACE);
        element.setAttribute("value", "#[if (attributes.headers['X-Forwarded-For'] != null) trim((attributes.headers['X-Forwarded-For'] splitBy  ',')[0]) else attributes.remoteAddress]");
        this.handleFilter(element);
    }
}

