/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.sftp;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.file.FileConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SftpConfig
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String SFTP_NAMESPACE_PREFIX = "sftp";
    private static final String SFTP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/sftp";
    public static final Namespace SFTP_NAMESPACE = Namespace.getNamespace((String)"sftp", (String)"http://www.mulesoft.org/schema/mule/sftp");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'connector']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update SFTP connector config.";
    }

    public SftpConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SFTP_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        TransportsUtils.handleServiceOverrides((Element)object, (MigrationReport)report);
        this.handleInputImplicitConnectorRef(object, report);
        this.handleOutputImplicitConnectorRef(object, report);
        object.setName("config");
        object.setNamespace(SFTP_NAMESPACE);
        Element connection = new Element("connection", SFTP_NAMESPACE);
        object.addContent((Content)connection);
        if (object.getAttribute("maxConnectionPoolSize") != null && !"0".equals(object.getAttributeValue("maxConnectionPoolSize"))) {
            int maxConnectionPoolSize = Integer.valueOf(object.getAttributeValue("maxConnectionPoolSize"));
            connection.addContent((Content)new Element("pooling-profile", XmlDslUtils.CORE_NAMESPACE).setAttribute("exhaustedAction", "WHEN_EXHAUSTED_WAIT").setAttribute("maxActive", "" + maxConnectionPoolSize).setAttribute("maxIdle", "" + Math.min(8, maxConnectionPoolSize)).setAttribute("maxWait", "-1"));
        }
        object.removeAttribute("maxConnectionPoolSize");
        XmlDslUtils.migrateReconnection((Element)connection, (Element)object, (MigrationReport)report);
        Element proxyConfig = object.getChild("proxy-config", SFTP_NAMESPACE);
        if (proxyConfig != null) {
            proxyConfig.setName("sftp-proxy-config");
            connection.addContent((Content)proxyConfig.detach());
        }
        if (object.getAttribute("connectionTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"connectionTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"identityFile");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"passphrase");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"preferredAuthenticationMethods");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"knownHostsFile");
        FileConfig.handleChildElements(object, connection, report);
        this.handleInputSpecificAttributes(object, report);
        this.handleOutputSpecificAttributes(object, report);
        object.removeAttribute("autoDelete");
    }

    private void handleInputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("/*/mule:flow/sftp:inbound-endpoint[not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:inbound-endpoint[not(@connector-ref) and starts-with(@address, 'sftp://')]"));
    }

    private void handleOutputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/sftp' and local-name()='outbound-endpoint' and not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:outbound-endpoint[not(@connector-ref) and starts-with(@address, 'sftp://')]"));
    }

    private void makeImplicitConnectorRefsExplicit(Element object, MigrationReport report, List<Element> implicitConnectorRefs) {
        List availableConfigs = this.getApplicationModel().getNodes("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/sftp' and local-name()='config']");
        if (implicitConnectorRefs.size() > 0 && availableConfigs.size() > 1) {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                report.report("transports.manyConnectors", implicitConnectorRef, implicitConnectorRef, new String[]{SFTP_NAMESPACE_PREFIX, availableConfigs.stream().map(e -> e.getAttributeValue("name")).collect(Collectors.joining(", "))});
            }
        } else {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                implicitConnectorRef.setAttribute("connector-ref", object.getAttributeValue("name"));
            }
        }
    }

    private void handleInputSpecificAttributes(Element object, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/sftp' and local-name()='inbound-endpoint' and @connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:inbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToInboundEnpoint(object, (Element)e));
        object.removeAttribute("pollingFrequency");
        object.removeAttribute("fileAge");
        object.removeAttribute("sizeCheckWaitTime");
        object.removeAttribute("tempDirInbound");
        object.removeAttribute("useTempFileTimestampSuffix");
    }

    private void handleOutputSpecificAttributes(Element object, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/sftp' and local-name()='outbound-endpoint' and @connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:outbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToOutboundEndpoint(object, (Element)e));
        object.removeAttribute("outputPattern");
        object.removeAttribute("tempDirOutbound");
        object.removeAttribute("duplicateHandling");
    }

    private void passConnectorConfigToInboundEnpoint(Element object, Element listener) {
        Element schedulingStr = new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
        listener.addContent((Content)schedulingStr);
        Element fixedFrequency = new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
        fixedFrequency.setAttribute("frequency", object.getAttributeValue("pollingFrequency", "1000"));
        schedulingStr.addContent((Content)fixedFrequency);
        if (listener.getAttribute("autoDelete") == null && object.getAttribute("autoDelete") != null) {
            listener.setAttribute("autoDelete", object.getAttributeValue("autoDelete"));
        }
        if (listener.getAttribute("fileAge") == null && object.getAttribute("fileAge") != null) {
            listener.setAttribute("fileAge", object.getAttributeValue("fileAge"));
        }
        if (listener.getAttribute("sizeCheckWaitTime") == null && object.getAttribute("sizeCheckWaitTime") != null) {
            listener.setAttribute("sizeCheckWaitTime", object.getAttributeValue("sizeCheckWaitTime"));
        }
        if (listener.getAttribute("tempDirInbound") == null && object.getAttribute("tempDir") != null) {
            listener.setAttribute("tempDir", object.getAttributeValue("tempDirInbound"));
        }
        if (listener.getAttribute("useTempFileTimestampSuffix") == null && object.getAttribute("useTempFileTimestampSuffix") != null) {
            listener.setAttribute("useTempFileTimestampSuffix", object.getAttributeValue("useTempFileTimestampSuffix"));
        }
    }

    private void passConnectorConfigToOutboundEndpoint(Element object, Element write) {
        if (object.getAttribute("outputPattern") != null) {
            write.setAttribute("outputPatternConfig", object.getAttributeValue("outputPattern"));
        }
        if (write.getAttribute("tempDirOutbound") == null && object.getAttribute("tempDir") != null) {
            write.setAttribute("tempDir", object.getAttributeValue("tempDirOutbound"));
        }
        if (write.getAttribute("duplicateHandling") == null && object.getAttribute("duplicateHandling") != null) {
            write.setAttribute("duplicateHandling", object.getAttributeValue("duplicateHandling"));
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

