/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.validation;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ValidationMigration
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String VALIDATION_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/validation";
    public static final Namespace VALIDATION_NAMESPACE = Namespace.getNamespace((String)"validation", (String)"http://www.mulesoft.org/schema/mule/validation");
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/validation']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Migrate Validation Module.";
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public ValidationMigration() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{VALIDATION_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("email"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("ip"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("url"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("time"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("pattern"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("locale"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("value"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("regex"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("caseSensitive"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("min"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("max"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("expression"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("minValue"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("maxValue"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("numberType"), (ExpressionMigrator)this.getExpressionMigrator());
        if (element.getName().equals("is-empty")) {
            element.setName("is-empty-collection");
        } else if (element.getName().equals("is-not-empty")) {
            element.setName("is-not-empty-collection");
        }
    }

    protected void addValidationsModule(Document document) {
        ValidationMigration.addValidationNamespace(document);
        ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
    }

    public static void addValidationNamespace(Document document) {
        ApplicationModel.addNameSpace((Namespace)VALIDATION_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/validation/current/mule-validation.xsd", (Document)document);
    }
}

