/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.vm;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.vm.AbstractVmEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class VmInboundEndpoint
extends AbstractVmEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/vm' and local-name()='inbound-endpoint']";

    public String getDescription() {
        return "Update VM transport inbound endpoint.";
    }

    public VmInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{VM_NAMESPACE}));
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("BEGIN_OR_JOIN".equals(action)) {
            report.report("vm.listenerTx", tx, object, new String[0]);
            return "ALWAYS_BEGIN";
        }
        if ("ALWAYS_JOIN".equals(action)) {
            report.report("vm.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("JOIN_IF_POSSIBLE".equals(action)) {
            report.report("vm.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("NOT_SUPPORTED".equals(action)) {
            return "NONE";
        }
        return action;
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        String txAction;
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        Element tx = object.getChild("transaction", VM_NAMESPACE);
        while (tx != null) {
            String txAction2 = this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object);
            object.setAttribute("transactionalAction", txAction2);
            if (!"NONE".equals(txAction2) && object.getChild("redelivery-policy", XmlDslUtils.CORE_NAMESPACE) == null) {
                object.addContent((Content)new Element("redelivery-policy", XmlDslUtils.CORE_NAMESPACE));
            }
            object.removeChild("transaction", VM_NAMESPACE);
            tx = object.getChild("transaction", VM_NAMESPACE);
        }
        while (object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE) != null) {
            Element xaTx = object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
            txAction = this.mapTransactionalAction(xaTx.getAttributeValue("action"), report, xaTx, object);
            object.setAttribute("transactionalAction", txAction);
            object.setAttribute("transactionType", "XA");
            if (!"NONE".equals(txAction) && object.getChild("redelivery-policy", XmlDslUtils.CORE_NAMESPACE) == null) {
                object.addContent((Content)new Element("redelivery-policy", XmlDslUtils.CORE_NAMESPACE));
            }
            if ("true".equals(xaTx.getAttributeValue("interactWithExternal"))) {
                report.report("vm.externalTx", xaTx, object, new String[0]);
            }
            object.removeChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
        }
        while (object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE) != null) {
            Element multiTx = object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
            txAction = this.mapTransactionalAction(multiTx.getAttributeValue("action"), report, multiTx, object);
            object.setAttribute("transactionalAction", txAction);
            if (!"NONE".equals(txAction) && object.getChild("redelivery-policy", XmlDslUtils.CORE_NAMESPACE) == null) {
                object.addContent((Content)new Element("redelivery-policy", XmlDslUtils.CORE_NAMESPACE));
            }
            object.removeChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
        }
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)VM_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd", (Document)object.getDocument());
        object.setNamespace(VM_NAMESPACE);
        object.setName("listener");
        Optional<Element> connector = VmInboundEndpoint.resolveVmConector(object, this.getApplicationModel());
        String configName = VmInboundEndpoint.getVmConfigName(object, connector);
        Element vmConfig = VmInboundEndpoint.migrateVmConfig(object, connector, configName, this.getApplicationModel());
        String path = TransportsUtils.processAddress((Element)object, (MigrationReport)report).map(address -> address.getPath()).orElseGet(() -> VmInboundEndpoint.obtainPath(object));
        VmInboundEndpoint.addQueue(VM_NAMESPACE, connector, vmConfig, path);
        connector.ifPresent(conn -> {
            TransportsUtils.handleServiceOverrides((Element)conn, (MigrationReport)report);
            String consumers = null;
            if (conn.getAttribute("numberOfConcurrentTransactedReceivers") != null) {
                consumers = conn.getAttributeValue("numberOfConcurrentTransactedReceivers");
            } else if (conn.getChild("receiver-threading-profile", XmlDslUtils.CORE_NAMESPACE) != null && conn.getChild("receiver-threading-profile", XmlDslUtils.CORE_NAMESPACE).getAttribute("maxThreadsActive") != null) {
                consumers = conn.getChild("receiver-threading-profile", XmlDslUtils.CORE_NAMESPACE).getAttributeValue("maxThreadsActive");
            }
            if (consumers != null) {
                XmlDslUtils.getContainerElement((Element)object).setAttribute("maxConcurrency", consumers);
                object.setAttribute("numberOfConsumers", consumers);
            }
            TransportsUtils.handleConnectorChildElements((Element)conn, (Element)vmConfig, (Element)new Element("connection", XmlDslUtils.CORE_NAMESPACE), (MigrationReport)report);
        });
        if (object.getAttribute("mimeType") != null) {
            Element setMimeType = new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[output " + object.getAttributeValue("mimeType") + " --- payload]");
            XmlDslUtils.addElementAfter((Element)setMimeType, (Element)object);
            object.removeAttribute("mimeType");
        }
        if (object.getAttribute("responseTimeout") != null) {
            object.setAttribute("timeout", object.getAttributeValue("responseTimeout"));
            object.setAttribute("timeoutUnit", "MILLISECONDS");
            object.removeAttribute("responseTimeout");
        }
        object.setAttribute("config-ref", configName);
        object.setAttribute("queueName", path);
        object.removeAttribute("path");
        object.removeAttribute("name");
        object.removeAttribute("disableTransportTransformer");
        Element content = VmInboundEndpoint.buildContent(VM_NAMESPACE);
        object.addContent((Content)new Element("response", VM_NAMESPACE).addContent((Content)content));
        report.report("vm.sessionVars", content, content, new String[0]);
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("one-way")) {
            TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)false, (boolean)true);
        } else {
            TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true, (boolean)true);
        }
    }
}

