/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools;

import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SalesforceUtils {
    public static final String MULE3_SALESFORCE_NAMESPACE_PREFIX = "sfdc";
    public static final String MULE3_SALESFORCE_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/sfdc";
    public static final Namespace MULE3_SALESFORCE_NAMESPACE = Namespace.getNamespace((String)"sfdc", (String)"http://www.mulesoft.org/schema/mule/sfdc");
    public static final String MULE4_SALESFORCE_NAMESPACE_PREFIX = "salesforce";
    public static final String MULE4_SALESFORCE_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/salesforce";
    public static final Namespace MULE4_SALESFORCE_NAMESPACE = Namespace.getNamespace((String)"salesforce", (String)"http://www.mulesoft.org/schema/mule/salesforce");
    public static final String MULE4_SALESFORCE_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/salesforce/current/mule-salesforce.xsd";
    public static final String DOC_NAMESPACE_PREFIX = "doc";
    public static final String DOC_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/documentation";
    public static final Namespace DOC_NAMESPACE = Namespace.getNamespace((String)"doc", (String)"http://www.mulesoft.org/schema/mule/documentation");
    public static final String START_TRANSFORM_BODY_TYPE_JSON = "%dw 2.0 output application/json\n---\n[{\n";
    public static final String START_TRANSFORM_BODY_TYPE_JAVA = "%dw 2.0 output application/java\n---\n{\n";
    public static final String CLOSE_TRANSFORM_BODY_TYPE_JSON = "\n}]";

    public static void migrateRecordsFromExpression(Element records, Element mule4Operation, ExpressionMigrator expressionMigrator, String mule4ElementName) {
        Optional.ofNullable(records.getAttributeValue("ref")).ifPresent(value -> {
            Element recordsChild = new Element(mule4ElementName, MULE4_SALESFORCE_NAMESPACE);
            String expression = expressionMigrator.migrateExpression(value, true, records);
            recordsChild.setContent((Content)new CDATA(expression));
            mule4Operation.addContent((Content)recordsChild);
        });
    }

    public static void createTransformBeforeElement(Element mule3Operation, String transformBody) {
        Element element = new Element("transform");
        element.setName("transform");
        element.setNamespace(XmlDslUtils.CORE_EE_NAMESPACE);
        element.removeContent();
        element.addContent((Content)new Element("message", XmlDslUtils.CORE_EE_NAMESPACE).addContent((Content)new Element("set-payload", XmlDslUtils.CORE_EE_NAMESPACE).setText(transformBody)));
        XmlDslUtils.addElementBefore((Element)element, (Element)mule3Operation);
    }

    public static void createTransformAfterElementToMatchOutputs(Element mule4Operation, String transformBody) {
        Element element = new Element("transform");
        element.setName("transform");
        element.setNamespace(XmlDslUtils.CORE_EE_NAMESPACE);
        element.removeContent();
        element.addContent((Content)new Element("message", XmlDslUtils.CORE_EE_NAMESPACE).addContent((Content)new Element("set-payload", XmlDslUtils.CORE_EE_NAMESPACE).setText(transformBody)));
        XmlDslUtils.addElementAfter((Element)element, (Element)mule4Operation);
    }

    public static String getTransformBodyToMatchCreateAndUpdateOutputs() {
        return "%dw 2.0\noutput application/json\n---\npayload.items map ( item , indexOfItem ) -> {\n\tsuccess: item.successful default true,\n\twrapped: {\n\t\tsuccess: item.payload.success default true,\n\t\terrors: item.payload.errors map ( error , indexOfError ) -> error,\n\t\tid: item.payload.id default \"\"\n\t},\n\terrors: item.payload.errors map ( error , indexOfError ) -> error,\n\tid: item.id as String default \"\"\n}";
    }

    public static String getTransformBodyToMatchUpsertOutputs() {
        return "%dw 2.0\noutput application/json\n---\npayload.items map ( item , indexOfItem ) -> {\n\tcreated: item.payload.created default true,\n\tsuccess: item.successful default true,\n\tpayload: {\n\t\tid: item.id as String default \"\"\n\t},\n\terrors: item.payload.errors map ( error , indexOfError ) -> error,\n\tid: item.id as String default \"\"\n}";
    }

    public static void resolveTypeAttribute(Element mule3Operation, Element mule4Operation) {
        String type = mule3Operation.getAttributeValue("type");
        if (type != null && !type.isEmpty()) {
            mule4Operation.setAttribute("type", type);
        }
    }
}

