/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel;

import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Element;

public class WatermarkSelectorMigrator {
    public String migrateSelector(String expression, String selector, Element element, MigrationReport report, ExpressionMigrator expressionMigrator) {
        String migratedExpression = expressionMigrator.unwrap(expressionMigrator.migrateExpression(expression = expression.trim(), true, element));
        if (migratedExpression.startsWith("mel:")) {
            report.report("watermark.expression", element, element, new String[0]);
        } else {
            switch (selector) {
                case "min": {
                    migratedExpression = this.splitSelectorExpression(migratedExpression, "min");
                    break;
                }
                case "max": {
                    migratedExpression = this.splitSelectorExpression(migratedExpression, "max");
                    break;
                }
                case "first": {
                    migratedExpression = "#[" + migratedExpression + "[0]]";
                    break;
                }
                case "last": {
                    migratedExpression = "#[" + migratedExpression + "[-1]]";
                    break;
                }
                default: {
                    report.report("watermark.expression", element, element, new String[0]);
                }
            }
        }
        return migratedExpression;
    }

    private String splitSelectorExpression(String expression, String selector) {
        String rightExpression;
        String leftExpression;
        Integer lastIndDot = expression.lastIndexOf(".");
        if (lastIndDot != -1 && !expression.substring(lastIndDot + 1).endsWith("]")) {
            leftExpression = expression.substring(0, lastIndDot);
            rightExpression = expression.substring(lastIndDot + 1);
        } else {
            leftExpression = expression;
            rightExpression = "";
        }
        return "#[" + selector + "(" + leftExpression + " map $ " + rightExpression + ")]";
    }
}

