/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.mulesoft.tools.migration.library.apikit.steps.AbstractApikitMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApikitNamespace
extends AbstractApikitMigrationStep {
    private static final String OLD_APIKIT_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/apikit";
    private static final String OLD_APIKIT_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/apikit/current/mule-apikit.xsd";
    private static final Namespace OLD_APIKIT_NAMESPACE = Namespace.getNamespace((String)"apikit", (String)"http://www.mulesoft.org/schema/mule/apikit");
    private static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/apikit']";
    private boolean namespaceUpdated = false;

    public String getDescription() {
        return "Update APIkit namespace";
    }

    public ApikitNamespace() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.getNamespacesContributions().add(OLD_APIKIT_NAMESPACE);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Document document = element.getDocument();
        if (!this.namespaceUpdated) {
            this.getApplicationModel().removeNameSpace(OLD_APIKIT_NAMESPACE, OLD_APIKIT_SCHEMA_LOCATION, document);
            ApplicationModel.addNameSpace((Namespace)APIKIT_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/mule-apikit/current/mule-apikit.xsd", (Document)document);
            this.namespaceUpdated = true;
        }
        element.setNamespace(APIKIT_NAMESPACE);
    }
}

