/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.federation;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.PolicyMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.FederationBadResponseOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.FederationForbiddenErrorOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.FederationInvalidTokenOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.FederationNotAuthorizedConnectionErrorOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractFederationValidateMigrationStep
extends PolicyMigrationStep {
    protected static final String VALIDATE_TAG_NAME = "validate";
    private static final String THROW_ON_UNACCEPTED_ATTR_NAME = "throwOnUnaccepted";
    private static final String ON_UNACCEPTED_ATTR_NAME = "onUnaccepted";
    private static final String SUB_FLOW_TAG_NAME = "sub-flow";
    private static final String ACCESS_TOKEN_ATTR_NAME = "accessToken";
    private static final String ACCESS_TOKEN_ATTR_VALUE = "#[attributes.queryParams['access_token']]";
    private static final String AUTHORIZATION_ATTR_NAME = "authorization";
    private static final String AUTHORIZATION_ATTR_VALUE = "#[attributes.headers['authorization']]";
    protected static final String CONFIG_REF_ATTR_NAME = "config-ref";
    private static final String CONFIG_VALUE = "config";
    private static final String SET_VARIABLE_TAG_NAME = "set-variable";
    private static final String VARIABLE_NAME_ATTR_NAME = "variableName";
    private static final String VARIABLE_NAME_ATTR_VALUE = "federationProperties";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String VALUE_ATTR_VALUE = "#[authentication.properties.userProperties]";
    private static final String OPERATION_TAG_NAME = "operation";
    private static final String ADD_REQUEST_HEADERS_TAG_NAME = "add-request-headers";
    private static final String HEADERS_TAG_NAME = "headers";
    private static final String HEADERS_CONTENT_VALUE = "#[vars.federationProperties filterObject ( not ($ is Object or $ is Array)) mapObject ((\"X-AGW-\" ++ ($$ replace ' ' with '-')):$)]";
    private static final String FEDERATION_XSI_SCHEMA_LOCATION_URI = "http://www.mulesoft.org/schema/mule/federation http://www.mulesoft.org/schema/mule/federation/current/mule-federation.xsd";
    private static final String HTTP_TRANSFORM_XSI_SCHEMA_LOCATION_URI = "http://www.mulesoft.org/schema/mule/http-policy-transform http://www.mulesoft.org/schema/mule/http-policy-transform/current/mule-http-policy-transform.xsd";

    public AbstractFederationValidateMigrationStep(Namespace namespace, String tagName) {
        super(namespace, tagName);
    }

    private void removeProcessorChainElement(Element rootElement, String onUnacceptedName) {
        Element processorChainElement = rootElement.getChildren(SUB_FLOW_TAG_NAME, GatewayNamespaces.MULE_4_POLICY_NAMESPACE).stream().filter(element -> element.getAttributeValue("name").equals(onUnacceptedName)).findFirst().orElse(null);
        if (processorChainElement != null) {
            processorChainElement.detach();
        }
    }

    private void setConfigElement(Element rootElement, Element validateElement, List<Attribute> attributes) {
        Element oauth2ConfigElement = new Element(this.getConfigElementTagName(), GatewayNamespaces.FEDERATION_NAMESPACE).setAttribute("name", CONFIG_VALUE);
        attributes.forEach(attr -> oauth2ConfigElement.setAttribute(attr.clone()));
        new ArrayList<Attribute>(attributes).forEach(attr -> validateElement.removeAttribute(attr));
        rootElement.addContent((Content)oauth2ConfigElement);
    }

    private void setBeforeElements(Element validateElement) {
        validateElement.setName(this.getAuthenticateElementTagName());
        validateElement.setNamespace(GatewayNamespaces.FEDERATION_NAMESPACE);
        validateElement.setAttribute(ACCESS_TOKEN_ATTR_NAME, ACCESS_TOKEN_ATTR_VALUE);
        validateElement.setAttribute(AUTHORIZATION_ATTR_NAME, AUTHORIZATION_ATTR_VALUE);
        validateElement.setAttribute(CONFIG_REF_ATTR_NAME, CONFIG_VALUE);
        validateElement.getParentElement().addContent((Content)new Element(SET_VARIABLE_TAG_NAME, GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX).setAttribute(VARIABLE_NAME_ATTR_NAME, VARIABLE_NAME_ATTR_VALUE).setAttribute(VALUE_ATTR_NAME, VALUE_ATTR_VALUE));
    }

    private void addOnErrorContinueElements(Element errorHandlerElement) {
        new FederationNotAuthorizedConnectionErrorOnErrorContinueElementWriter(this.getHeadersAuthenticateContent()).create(errorHandlerElement, true);
        new FederationInvalidTokenOnErrorContinueElementWriter().create(errorHandlerElement, true);
        new FederationForbiddenErrorOnErrorContinueElementWriter().create(errorHandlerElement, true);
        new FederationBadResponseOnErrorContinueElementWriter().create(errorHandlerElement, true);
    }

    private void completeTryElementWithOperationContent(Element tryElement) {
        Element errorHandlerElement = tryElement.getChild("error-handler", GatewayNamespaces.MULE_4_POLICY_NAMESPACE);
        if (errorHandlerElement == null) {
            errorHandlerElement = new Element("error-handler", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            this.addOnErrorContinueElements(errorHandlerElement);
            tryElement.addContent((Content)errorHandlerElement);
        } else {
            this.addOnErrorContinueElements(errorHandlerElement);
        }
    }

    private void completeSourceElement(Element sourceElement) {
        Element tryElement = sourceElement.getChild("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
        if (tryElement == null) {
            tryElement = new Element("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            List<Content> sourceCloneContentList = this.detachContent(sourceElement.getContent());
            sourceElement.addContent((Content)tryElement);
            sourceCloneContentList.forEach(arg_0 -> ((Element)tryElement).addContent(arg_0));
        }
        this.completeTryElementWithOperationContent(tryElement);
    }

    private void addOperationElement(Element proxyElement) {
        proxyElement.addContent((Content)new Element(OPERATION_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE).addContent((Content)new Element(ADD_REQUEST_HEADERS_TAG_NAME, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE).addContent((Content)new Element(HEADERS_TAG_NAME, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE).addContent(HEADERS_CONTENT_VALUE))).addContent((Content)new Element("execute-next", GatewayNamespaces.HTTP_POLICY_NAMESPACE)));
    }

    private void addNamespaceDeclarations(Element rootElement) {
        this.addNamespaceDeclaration(rootElement, GatewayNamespaces.FEDERATION_NAMESPACE, FEDERATION_XSI_SCHEMA_LOCATION_URI);
        this.addNamespaceDeclaration(rootElement, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE, HTTP_TRANSFORM_XSI_SCHEMA_LOCATION_URI);
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        element.removeAttribute(THROW_ON_UNACCEPTED_ATTR_NAME);
        Element rootElement = this.getRootElement(element);
        this.addNamespaceDeclarations(rootElement);
        this.removeProcessorChainElement(rootElement, element.getAttributeValue(ON_UNACCEPTED_ATTR_NAME));
        element.removeAttribute(ON_UNACCEPTED_ATTR_NAME);
        this.setConfigElement(rootElement, element, element.getAttributes());
        this.setBeforeElements(element);
        Element sourceElement = this.setUpHttpPolicy(element, false, migrationReport);
        this.completeSourceElement(sourceElement);
        this.addOperationElement(sourceElement.getParentElement());
    }

    protected abstract String getConfigElementTagName();

    protected abstract String getAuthenticateElementTagName();

    protected abstract String getHeadersAuthenticateContent();
}

