/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.ipfilter;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.PolicyMigrationStep;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractIpFilterMigrationStep
extends PolicyMigrationStep {
    protected static final String CONFIG_TAG_NAME = "config";
    protected static final String NAME_TAG_NAME = "name";
    protected static final String IPS_TAG_NAME = "ips";
    protected static final String IP_ADDRESS_ATTR_NAME = "ipAddress";

    public AbstractIpFilterMigrationStep(Namespace namespace, String tagName) {
        super(namespace, tagName);
    }

    protected AbstractIpFilterMigrationStep() {
    }

    protected Element getConfigElementFromDocument(Element root) {
        return root.getChild(CONFIG_TAG_NAME, GatewayNamespaces.IP_FILTER_NAMESPACE);
    }

    protected boolean hasConfigTag(Element root) {
        return root != null && this.getConfigElementFromDocument(root) != null;
    }

    private Attribute getIpAddressAttr(Element root) {
        return this.getConfigElementFromDocument(root).getAttribute(IP_ADDRESS_ATTR_NAME).detach();
    }

    protected void setIpAddressAttribute(Element element) {
        Element root = this.getRootElement(element);
        if (this.hasConfigTag(root)) {
            element.setAttribute(this.getIpAddressAttr(root));
        }
    }

    private void setConfigNameAttribute(Element element, String configRefAttrValue) {
        Element root = this.getRootElement(element);
        if (this.hasConfigTag(root)) {
            this.getConfigElementFromDocument(root).setAttribute(new Attribute(NAME_TAG_NAME, configRefAttrValue));
        }
    }

    protected void moveBlacklistWhitelistContent(Element element) {
        List<Content> content = this.detachContent(element.getContent());
        Element root = this.getRootElement(element);
        if (this.hasConfigTag(root)) {
            this.getConfigElementFromDocument(root).getChild(IPS_TAG_NAME, GatewayNamespaces.IP_FILTER_NAMESPACE).addContent(content);
        }
    }

    protected void migrateBlacklistWhitelistElement(Element element, String configRefAttrValue) {
        element.setNamespace(GatewayNamespaces.IP_FILTER_NAMESPACE);
        element.setAttribute(new Attribute("config-ref", configRefAttrValue));
        this.setIpAddressAttribute(element);
        this.setConfigNameAttribute(element, configRefAttrValue);
        this.moveBlacklistWhitelistContent(element);
    }
}

