/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.throttling;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.throttling.AbstractThrottlingMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.throttling.ThrottlingPomContributionMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.ForbiddenClientOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.QuotaExceededOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.library.gateway.steps.policy.utils.UnknownApiOnErrorContinueElementWriter;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class SlaBasedAlgorithmMigrationStep
extends AbstractThrottlingMigrationStep {
    private static final String SLA_BASED_ALGORITHM = "sla-based-algorithm";
    private static final String CONFIG_NAME_ATTR_VALUE_RATE_LIMIT_SLA = "rateLimitSlaConfig";
    private static final String VALIDATE_CLIENT_TAG_NAME = "validate-client";
    private static final String API_ID_ATTR_NAME = "apiId";
    private static final String API_ID_ATTR_VALUE = "${apiId}";
    private static final String ID_ATTR_VALUE_RATE_LIMIT_SLA = "{{policyId}}-rate-limit-sla";
    private static final String CLIENT_ID_ATTR_NAME = "clientId";
    private static final String CLIENT_SECRET_ATTR_NAME = "clientSecret";
    private static final String CLIENT_ID_EXPRESSION_ATTR_NAME = "clientIdExpression";
    private static final String CLIENT_SECRET_EXPRESSION_ATTR_NAME = "clientSecretExpression";

    public SlaBasedAlgorithmMigrationStep() {
        super(GatewayNamespaces.API_PLATFORM_GW_MULE_3_NAMESPACE, SLA_BASED_ALGORITHM);
    }

    private void checkThrottlingSLAPolicy(Element slaBasedAlgorithmElement, MigrationReport migrationReport) {
        Element parentElement = slaBasedAlgorithmElement.getParentElement();
        if (parentElement.getChild("delay-response", GatewayNamespaces.THROTTLING_GW_MULE_3_NAMESPACE) != null) {
            migrationReport.report("throttling.throttlingSLANotSupported", parentElement, parentElement, new String[0]);
        }
    }

    private boolean configElementExists(Element rootElement) {
        List configElements = rootElement.getChildren("config", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
        return configElements.stream().filter(configElement -> {
            Element tierProviderElement;
            if (configElement != null && configElement.getAttributeValue("name").equals(CONFIG_NAME_ATTR_VALUE_RATE_LIMIT_SLA) && configElement.getAttributeValue("clusterizable").equals("true") && (tierProviderElement = configElement.getChild("tier-provider", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE)) != null) {
                Element validateClientElement = tierProviderElement.getChild(VALIDATE_CLIENT_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE);
                return validateClientElement != null && validateClientElement.getAttributeValue(API_ID_ATTR_NAME).equals(API_ID_ATTR_VALUE);
            }
            return false;
        }).findAny().orElse(null) != null;
    }

    private void addConfigElement(Element slaBasedAlgorithmAlgorithmElement) {
        Element rootElement = this.getRootElement(slaBasedAlgorithmAlgorithmElement);
        if (!this.configElementExists(rootElement)) {
            rootElement.addContent((Content)new Element("config", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).setAttribute("name", CONFIG_NAME_ATTR_VALUE_RATE_LIMIT_SLA).setAttribute("clusterizable", "true").addContent((Content)new Element("tier-provider", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).addContent((Content)new Element(VALIDATE_CLIENT_TAG_NAME, GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).setAttribute(API_ID_ATTR_NAME, API_ID_ATTR_VALUE))));
        }
    }

    private Element getOperationElement(Element slaBasedAlgorithmAlgorithmElement) {
        return new Element("rate-limit", GatewayNamespaces.THROTTLING_MULE_4_NAMESPACE).setAttribute("id", ID_ATTR_VALUE_RATE_LIMIT_SLA).setAttribute("config-ref", CONFIG_NAME_ATTR_VALUE_RATE_LIMIT_SLA).setAttribute("target", "throttlingResponse").setAttribute(CLIENT_ID_ATTR_NAME, slaBasedAlgorithmAlgorithmElement.getAttributeValue(CLIENT_ID_EXPRESSION_ATTR_NAME)).setAttribute(CLIENT_SECRET_ATTR_NAME, slaBasedAlgorithmAlgorithmElement.getAttributeValue(CLIENT_SECRET_EXPRESSION_ATTR_NAME));
    }

    private void addOnErrorContinueElements(Element errorHandlerElement) {
        new QuotaExceededOnErrorContinueElementWriter().create(errorHandlerElement, true);
        new ForbiddenClientOnErrorContinueElementWriter().create(errorHandlerElement, true);
        new UnknownApiOnErrorContinueElementWriter().create(errorHandlerElement, true);
    }

    private void completeTryElementWithOperationContent(Element tryElement, Element slaBasedAlgorithmAlgorithmElement) {
        tryElement.addContent(0, (Content)this.getOperationElement(slaBasedAlgorithmAlgorithmElement));
        this.addAddHeadersElement(tryElement);
        Element errorHandlerElement = tryElement.getChild("error-handler", GatewayNamespaces.MULE_4_POLICY_NAMESPACE);
        if (errorHandlerElement == null) {
            errorHandlerElement = new Element("error-handler", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            this.addOnErrorContinueElements(errorHandlerElement);
            errorHandlerElement.addContent((Content)this.getOnErrorPropagateElement());
            tryElement.addContent((Content)errorHandlerElement);
        } else {
            this.addOnErrorContinueElements(errorHandlerElement);
            this.addOnErrorPropagateElement(errorHandlerElement);
        }
    }

    private void addOperationElements(Element slaBasedAlgorithmAlgorithmElement, MigrationReport migrationReport) {
        Element source = this.setUpHttpPolicy(slaBasedAlgorithmAlgorithmElement, false, migrationReport);
        Element tryElement = source.getChild("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
        if (tryElement == null) {
            tryElement = new Element("try", GatewayNamespaces.MULE_4_CORE_NAMESPACE_NO_PREFIX);
            List<Content> sourceCloneContentList = this.detachContent(source.getContent());
            source.addContent((Content)tryElement);
            sourceCloneContentList.forEach(arg_0 -> ((Element)tryElement).addContent(arg_0));
        }
        this.completeTryElementWithOperationContent(tryElement, slaBasedAlgorithmAlgorithmElement);
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        this.checkThrottlingSLAPolicy(element, migrationReport);
        this.addConfigElement(element);
        this.addOperationElements(element, migrationReport);
        this.addNamespaceDeclarations(element);
        new ThrottlingPomContributionMigrationStep().execute((PomModel)this.getApplicationModel().getPomModel().get(), migrationReport);
    }
}

