/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.compression;

import com.mulesoft.tools.migration.library.mule.steps.compression.AbstractCompressionMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class GZipUncompressTransformer
extends AbstractCompressionMigrationStep {
    public static final String ORIGINAL_ELEMENT_NAME = "gzip-uncompress-transformer";
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"gzip-uncompress-transformer");

    public GZipUncompressTransformer() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public String getDescription() {
        return String.format("Update <%s /> to use the compression module", ORIGINAL_ELEMENT_NAME);
    }

    @Override
    protected String getStrategyName() {
        return "decompressor";
    }

    @Override
    protected String getOperationName() {
        return "decompress";
    }

    @Override
    protected void transformArguments(Element element, MigrationReport report) {
        Attribute encoding;
        super.transformArguments(element, report);
        Attribute mimeType = element.getAttribute("mimeType");
        if (mimeType != null) {
            mimeType.setName("outputMimeType");
        }
        if ((encoding = element.getAttribute("encoding")) != null) {
            encoding.setName("outputEncoding");
        }
    }
}

