/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class Flow
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = XmlDslUtils.getTopLevelCoreXPathSelector((String)"flow");

    public String getDescription() {
        return "Migrate flow definitions";
    }

    public Flow() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        String name = element.getAttributeValue("name");
        element.setAttribute("name", Flow.migrateFlowName(name));
        Attribute processingStrategy = element.getAttribute("processingStrategy");
        if (processingStrategy != null) {
            if ("synchronous".equals(processingStrategy.getValue())) {
                element.setAttribute("maxConcurrency", "1");
            } else {
                this.getApplicationModel().getNodeOptional("//*[@name = '" + processingStrategy.getValue() + "']").ifPresent(processingStrategyConfig -> {
                    processingStrategyConfig.detach();
                    if (processingStrategyConfig.getAttribute("maxThreads") != null) {
                        element.setAttribute("maxConcurrency", processingStrategyConfig.getAttribute("maxThreads").getValue());
                    }
                });
            }
            element.removeAttribute(processingStrategy);
            report.report("flow.processingStrategy", element, element, new String[0]);
        }
        ArrayList responses = new ArrayList(element.getChildren("response", XmlDslUtils.CORE_NAMESPACE));
        Collections.reverse(responses);
        for (Element response : responses) {
            Element wrappingTry = new Element("try", XmlDslUtils.CORE_NAMESPACE);
            new ArrayList<Content>(element.getContent().subList(element.indexOf((Content)response) + 1, element.getContentSize())).forEach(c -> {
                if (c instanceof Element && !XmlDslUtils.isErrorHanldingElement((Element)((Element)c))) {
                    c.detach();
                    wrappingTry.addContent(c);
                }
            });
            XmlDslUtils.addElementAfter((Element)wrappingTry, (Element)response);
            List contents = response.cloneContent();
            response.detach();
            for (Content content : contents) {
                XmlDslUtils.addElementToBottom((Element)element, (Content)content);
            }
        }
    }

    public static String migrateFlowName(String name) {
        return name.replaceAll("/", "\\\\").replaceAll("\\[|\\{", "(").replaceAll("\\]|\\}", ")").replaceAll("#", "_");
    }
}

