/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PropertyPlaceholder
extends AbstractApplicationModelMigrationStep {
    private static final String SPRING_CONTEXT_NS_PREFIX = "context";
    private static final String SPRING_CONTEXT_NS_URI = "http://www.springframework.org/schema/context";
    private static final String SPRING_CONTEXT_SCHEMA = "http://www.springframework.org/schema/context/spring-context.xsd";
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.springframework.org/schema/context' and local-name()='property-placeholder']";

    public String getDescription() {
        return "Migrate Property Placeholder component";
    }

    public PropertyPlaceholder() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Attribute propsLocation = element.getAttribute("location");
        if (propsLocation != null) {
            Element configProperties = new Element("configuration-properties", XmlDslUtils.CORE_NAMESPACE);
            configProperties.setAttribute("file", propsLocation.getValue());
            XmlDslUtils.addTopLevelElement((Element)configProperties, (Document)element.getDocument());
        }
        this.getApplicationModel().removeNameSpace(Namespace.getNamespace((String)SPRING_CONTEXT_NS_PREFIX, (String)SPRING_CONTEXT_NS_URI), SPRING_CONTEXT_SCHEMA, element.getDocument());
        element.detach();
    }
}

