/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.stream.Collectors;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RemoveMetadataAttributes
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//*[@*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/metadata']]";
    public static final Namespace METADATA_NAMESPACE = Namespace.getNamespace((String)"metadata", (String)"http://www.mulesoft.org/schema/mule/metadata");

    public String getDescription() {
        return "Remove metadata:id attribute.";
    }

    public RemoveMetadataAttributes() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        report.report("transform.studioCustomTypes", element, element, new String[0]);
        element.getAttributes().stream().filter(att -> att.getNamespace().equals((Object)METADATA_NAMESPACE)).collect(Collectors.toList()).forEach(att -> att.detach());
        element.removeNamespaceDeclaration(METADATA_NAMESPACE);
    }

    public boolean shouldReportMetrics() {
        return false;
    }
}

