/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AbstractFilterMigrator
extends ValidationMigration {
    private static final String DOCS_NAMESPACE_URL = "http://www.mulesoft.org/schema/mule/documentation";
    private static final String DOCS_NAMESPACE_PREFIX = "doc";
    private static final Namespace DOCS_NAMESPACE = Namespace.getNamespace((String)"doc", (String)"http://www.mulesoft.org/schema/mule/documentation");

    protected void handleFilter(Element filter) {
        Element flow;
        if (filter.getAttribute("name") != null) {
            Attribute nameAttribute = filter.getAttribute("name");
            if (filter.getAttribute("name", DOCS_NAMESPACE) != null) {
                nameAttribute.detach();
            } else {
                filter.getDocument().getRootElement().addNamespaceDeclaration(DOCS_NAMESPACE);
                nameAttribute.setNamespace(DOCS_NAMESPACE);
            }
        }
        if (!(filter.getParentElement().getNamespace().equals((Object)VALIDATION_NAMESPACE) && filter.getParentElement().getName().endsWith("filter") || (flow = XmlDslUtils.getContainerElement((Element)filter)) == null)) {
            if ("flow".equals(flow.getName())) {
                Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement((Element)flow);
                if (errorHandler == null) {
                    errorHandler = new Element("error-handler", XmlDslUtils.CORE_NAMESPACE);
                    flow.addContent((Content)errorHandler);
                }
                this.resolveValidationHandler(errorHandler);
            } else {
                Element wrappingTry = new Element("try", XmlDslUtils.CORE_NAMESPACE);
                XmlDslUtils.addElementAfter((Element)wrappingTry, (Element)filter);
                wrappingTry.addContent((Content)filter.clone());
                filter.detach();
                Element errorHandler = new Element("error-handler", XmlDslUtils.CORE_NAMESPACE);
                wrappingTry.addContent((Content)errorHandler);
                this.resolveValidationHandler(errorHandler);
            }
        }
    }

    protected Element resolveValidationHandler(Element errorHandler) {
        return errorHandler.getChildren().stream().filter(c -> "on-error-propagate".equals(c.getName()) && "MULE:VALIDATION".equals(c.getAttributeValue("type"))).findFirst().orElseGet(() -> {
            Element validationHandler = new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "MULE:VALIDATION").setAttribute("logException", "false");
            errorHandler.addContent(0, (Content)validationHandler);
            validationHandler.addContent((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", "filtered").setAttribute("value", "#[true]"));
            return validationHandler;
        });
    }
}

