/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpConnectorHeaders
extends AbstractHttpConnectorMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and (local-name()='header' or (local-name()='headers' and normalize-space(text())=''))]";

    public String getDescription() {
        return "Update HTTP headers in request/response builders.";
    }

    public HttpConnectorHeaders() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(HTTP_NAMESPACE);
        int idx = object.getParent().indexOf((Content)object);
        if ("headers".equals(object.getName()) && StringUtils.isEmpty((CharSequence)object.getText())) {
            String headersExpr = object.getAttributeValue("expression");
            this.setMule4MapBuilderTagText(idx, "headers", object.getParentElement(), HTTP_NAMESPACE, report, () -> this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(headersExpr), true, object), expr -> this.getExpressionMigrator().wrap(this.getExpressionMigrator().unwrap(expr) + " ++ " + this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(headersExpr), true, object))));
            object.getParent().removeContent((Content)object);
            XmlDslUtils.setText((Element)object, (String)this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(headersExpr), true, object));
        }
        if ("header".equals(object.getName())) {
            String headerName = object.getAttributeValue("headerName");
            String headerValue = object.getAttributeValue("value");
            String migratedName = this.getExpressionMigrator().migrateExpression(headerName, true, object.getParentElement());
            String migratedValue = this.getExpressionMigrator().migrateExpression(headerValue, true, object);
            String dwHeaderMapElement = this.migrateToDwMapKey(migratedName) + " : " + this.toExpressionOrToLiteral(migratedValue);
            this.setMule4MapBuilderTagText(idx, "headers", object.getParentElement(), HTTP_NAMESPACE, report, () -> this.getExpressionMigrator().wrap("{" + dwHeaderMapElement + "}"), expr -> this.getExpressionMigrator().wrap(this.getExpressionMigrator().unwrap(expr) + " ++ {" + dwHeaderMapElement + "}"));
            object.getParent().removeContent((Content)object);
        }
    }

    private String toExpressionOrToLiteral(String value) {
        return this.getExpressionMigrator().isWrapped(value) ? this.getExpressionMigrator().unwrap(value) : "'" + value + "'";
    }

    public String migrateToDwMapKey(String originalExpression) {
        return this.getExpressionMigrator().isWrapped(originalExpression) ? "(" + this.getExpressionMigrator().unwrap(originalExpression) + ")" : "'" + originalExpression + "'";
    }
}

