/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorRequester;
import com.mulesoft.tools.migration.library.mule.steps.http.SocketsConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpOutboundEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='outbound-endpoint']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update HTTP transport outbound endpoint.";
    }

    public HttpOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        HttpConnectorRequester.httpRequesterLib(this.getApplicationModel());
        object.setNamespace(AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
        object.setName("request");
        Element flow = XmlDslUtils.getContainerElement((Element)object);
        String flowName = flow.getAttributeValue("name") != null ? flow.getAttributeValue("name") : flow.getParentElement().getName() + StringUtils.capitalize((String)flow.getName());
        String configName = (object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : flowName)).replaceAll("\\\\", "_") + "RequestConfig";
        Optional nodeOptional = this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='request-config' and @name='" + configName + "']/*[namespace-uri()='" + "http://www.mulesoft.org/schema/mule/http" + "' and local-name()='request-connection']");
        if (nodeOptional.isPresent()) {
            configName = configName + object.getParentElement().indexOf((Content)object);
        }
        Element requestConfig = new Element("request-config", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("name", configName);
        Element requestConnection = new Element("request-connection", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
        requestConfig.addContent((Content)requestConnection);
        XmlDslUtils.addTopLevelElement((Element)requestConfig, (Document)nodeOptional.map(n -> n.getDocument()).orElse(object.getDocument()));
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"host");
        XmlDslUtils.migrateExpression((Attribute)requestConnection.getAttribute("host"), (ExpressionMigrator)this.expressionMigrator);
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"port");
        XmlDslUtils.migrateExpression((Attribute)requestConnection.getAttribute("port"), (ExpressionMigrator)this.expressionMigrator);
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            requestConnection.setAttribute("host", this.getExpressionMigrator().migrateExpression(address.getHost(), true, object));
            if (address.getPort() != null) {
                requestConnection.setAttribute("port", this.getExpressionMigrator().migrateExpression(address.getPort(), true, object));
            }
            if (address.getPath() != null) {
                object.setAttribute("path", this.getExpressionMigrator().migrateExpression(address.getPath(), true, object));
            }
        });
        if (object.getAttribute("keepAlive") != null || object.getAttribute("keep-alive") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"keep-alive", (String)"usePersistentConnections");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"keepAlive", (String)"usePersistentConnections");
        }
        if (object.getAttribute("path") == null) {
            object.setAttribute("path", "/");
        }
        object.setAttribute("config-ref", configName);
        if (object.getAttribute("connector-ref") != null) {
            Element connector2 = this.getConnector(object.getAttributeValue("connector-ref"));
            HttpOutboundEndpoint.handleConnector(connector2, requestConnection, report, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE, this.getApplicationModel());
            object.removeAttribute("connector-ref");
        } else {
            this.getDefaultConnector().ifPresent(connector -> HttpOutboundEndpoint.handleConnector(connector, requestConnection, report, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE, this.getApplicationModel()));
        }
        XmlDslUtils.migrateExpression((Attribute)object.getAttribute("method"), (ExpressionMigrator)this.expressionMigrator);
        if (object.getAttribute("method") == null) {
            object.setAttribute("method", "#[migration::HttpRequester::httpRequesterMethod(vars)]");
            object.setAttribute("sendBodyMode", this.getExpressionMigrator().wrap("if (migration::HttpRequester::httpRequesterMethod(vars) == 'DELETE') 'NEVER' else 'AUTO'"));
            report.report("http.method", object, object, new String[0]);
            report.report("http.sendBodyMode", object, object, new String[0]);
        } else if ("DELETE".equals(object.getAttributeValue("method"))) {
            object.setAttribute("sendBodyMode", "NEVER");
            report.report("http.sendBodyMode", object, object, new String[0]);
        } else if (this.getExpressionMigrator().isWrapped(object.getAttributeValue("method"))) {
            object.setAttribute("sendBodyMode", this.getExpressionMigrator().wrap("if (" + this.getExpressionMigrator().unwrap(object.getAttributeValue("method")) + " == 'DELETE') 'NEVER' else 'AUTO'"));
            report.report("http.sendBodyMode", object, object, new String[0]);
        }
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        HttpConnectorRequester.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
        if (object.getAttribute("contentType") != null) {
            String contentType = object.getAttributeValue("contentType").toLowerCase();
            if (contentType.startsWith("application/dw") || contentType.startsWith("application/java") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/csv") || contentType.startsWith("application/octet-stream") || contentType.startsWith("text/plain") || contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data") || contentType.startsWith("text/x-java-properties") || contentType.startsWith("application/yaml")) {
                object.getParentElement().addContent(object.getParentElement().indexOf((Content)object), (Content)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[output " + object.getAttributeValue("contentType") + " --- payload]"));
                object.removeAttribute("contentType");
            } else {
                object.addContent((Content)new Element("header", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("headerName", "Content-Type").setAttribute("value", object.getAttributeValue("contentType")));
            }
            object.removeAttribute("contentType");
        }
        object.addContent((Content)this.compatibilityHeaders(AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE));
        if (object.getAttribute("exceptionOnMessageError") != null && "false".equals(object.getAttributeValue("exceptionOnMessageError"))) {
            object.addContent((Content)new Element("response-validator", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).addContent((Content)new Element("success-status-code-validator", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("values", "0..599")));
            object.removeAttribute("exceptionOnMessageError");
        }
        if (object.getAttribute("name") != null) {
            object.removeAttribute("name");
        }
    }

    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector' and @name = '" + connectorName + "']");
    }

    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector']");
    }

    public static void handleConnector(Element connector, Element reqConnection, MigrationReport report, Namespace httpNamespace, ApplicationModel appModel) {
        TransportsUtils.handleServiceOverrides((Element)connector, (MigrationReport)report);
        if (connector.getAttribute("keepAlive") != null && reqConnection.getAttribute("usePersistentConnections") == null) {
            XmlDslUtils.copyAttributeIfPresent((Element)connector, (Element)reqConnection, (String)"keepAlive", (String)"usePersistentConnections");
        }
        if (connector.getAttribute("connectionTimeout") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("connectionTimeout", connector.getAttributeValue("connectionTimeout"));
        }
        if (connector.getAttribute("clientSoTimeout") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("clientTimeout", connector.getAttributeValue("clientSoTimeout"));
        }
        if (connector.getAttribute("sendTcpNoDelay") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("sendTcpNoDelay", connector.getAttributeValue("sendTcpNoDelay"));
        }
        if (connector.getAttribute("sendBufferSize") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("sendBufferSize", connector.getAttributeValue("sendBufferSize"));
        }
        if (connector.getAttribute("receiveBufferSize") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("receiveBufferSize", connector.getAttributeValue("receiveBufferSize"));
        }
        if (connector.getAttribute("socketSoLinger") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("linger", connector.getAttributeValue("socketSoLinger"));
        }
        if (connector.getAttribute("failOnUnresolvedHost") != null) {
            HttpOutboundEndpoint.getSocketProperties(reqConnection, httpNamespace, appModel).setAttribute("failOnUnresolvedHost", connector.getAttributeValue("failOnUnresolvedHost"));
        }
        if (connector.getAttribute("proxyHostname") != null) {
            HttpOutboundEndpoint.getProxyConfig(reqConnection, httpNamespace).setAttribute("host", connector.getAttributeValue("proxyHostname"));
        }
        if (connector.getAttribute("proxyPort") != null) {
            HttpOutboundEndpoint.getProxyConfig(reqConnection, httpNamespace).setAttribute("port", connector.getAttributeValue("proxyPort"));
        }
        if (connector.getAttribute("proxyUsername") != null) {
            HttpOutboundEndpoint.getProxyConfig(reqConnection, httpNamespace).setAttribute("username", connector.getAttributeValue("proxyUsername"));
        }
        if (connector.getAttribute("proxyPassword") != null) {
            HttpOutboundEndpoint.getProxyConfig(reqConnection, httpNamespace).setAttribute("password", connector.getAttributeValue("proxyPassword"));
        }
        if (connector.getAttribute("enableCookies") != null) {
            report.report("http.cookies", connector, reqConnection, new String[0]);
            XmlDslUtils.copyAttributeIfPresent((Element)connector, (Element)reqConnection.getParentElement(), (String)"enableCookies");
        }
        if (connector.getDocument().getRootElement().getName().equals("domain")) {
            report.report("transports.domainConnector", connector, connector, new String[0]);
        }
    }

    private static Element getSocketProperties(Element reqConnection, Namespace httpNamespace, ApplicationModel appModel) {
        SocketsConfig.addSocketsModule(appModel);
        Element clientSocket = reqConnection.getChild("client-socket-properties", httpNamespace);
        if (clientSocket != null) {
            Element tcpClientSocket = clientSocket.getChild("tcp-client-socket-properties", SocketsConfig.SOCKETS_NAMESPACE);
            if (tcpClientSocket != null) {
                return tcpClientSocket;
            }
            tcpClientSocket = new Element("tcp-client-socket-properties", SocketsConfig.SOCKETS_NAMESPACE);
            clientSocket.addContent((Content)tcpClientSocket);
            return tcpClientSocket;
        }
        Element socketProps = new Element("tcp-client-socket-properties", SocketsConfig.SOCKETS_NAMESPACE);
        reqConnection.addContent((Content)new Element("client-socket-properties", httpNamespace).addContent((Content)socketProps));
        return socketProps;
    }

    private static Element getProxyConfig(Element reqConnection, Namespace httpNamespace) {
        Element clientSocket = reqConnection.getChild("proxy-config", httpNamespace);
        if (clientSocket != null) {
            Element tcpClientSocket = clientSocket.getChild("proxy", httpNamespace);
            if (tcpClientSocket != null) {
                return tcpClientSocket;
            }
            tcpClientSocket = new Element("proxy", httpNamespace);
            clientSocket.addContent((Content)tcpClientSocket);
            return tcpClientSocket;
        }
        Element socketProps = new Element("proxy", httpNamespace);
        reqConnection.addContent((Content)new Element("proxy-config", httpNamespace).addContent((Content)socketProps));
        return socketProps;
    }

    public void executeChild(Element object, MigrationReport report, Namespace httpNamespace) throws RuntimeException {
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.executeChild((Element)c, report, httpNamespace);
            }
        });
        if ("request-builder".equals(object.getName())) {
            this.handleReferencedRequestBuilder(object, httpNamespace);
            object.addContent((Content)this.compatibilityHeaders(httpNamespace));
        }
    }

    private Element compatibilityHeaders(Namespace httpNamespace) {
        return XmlDslUtils.setText((Element)new Element("headers", httpNamespace), (String)"#[migration::HttpRequester::httpRequesterTransportHeaders(vars)]");
    }

    private void handleReferencedRequestBuilder(Element object, Namespace httpNamespace) {
        Element builderRef = object.getChild("builder", httpNamespace);
        int idx = 0;
        while (builderRef != null) {
            object.removeContent((Content)builderRef);
            Element builder = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='request-builder' and @name='" + builderRef.getAttributeValue("ref") + "']");
            this.handleReferencedRequestBuilder(builder, httpNamespace);
            ImmutableList builderContent = ImmutableList.copyOf((Collection)builder.getChildren()).asList();
            builder.setContent(Collections.emptyList());
            builder.getParent().removeContent((Content)builder);
            object.addContent(idx, (Collection)builderContent);
            idx += builderContent.size();
            builderRef = object.getChild("builder", httpNamespace);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

