/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpInboundEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpsInboundEndpoint
extends HttpInboundEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/https' and local-name() = 'inbound-endpoint' and position() = 1]";

    @Override
    public String getDescription() {
        return "Update HTTPs transport inbound endpoint.";
    }

    public HttpsInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        Element httpsConnector = null;
        if (object.getAttribute("connector-ref") != null) {
            httpsConnector = this.getConnector(object.getAttributeValue("connector-ref"));
        } else {
            Optional<Element> defaultConnector = this.getDefaultConnector();
            if (defaultConnector.isPresent()) {
                httpsConnector = defaultConnector.get();
            }
        }
        super.execute(object, report);
        HttpsInboundEndpoint.handleHttpsListenerConfig(this.getApplicationModel(), object, report, httpsConnector);
    }

    public static void handleHttpsListenerConfig(ApplicationModel appModel, Element object, MigrationReport report, Element httpsConnector) {
        Element httpsListenerConnection = appModel.getNode("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/http' and local-name() = 'listener-config' and @name = '" + object.getAttributeValue("config-ref") + "']/*[namespace-uri() = '" + "http://www.mulesoft.org/schema/mule/http" + "' and local-name() = 'listener-connection']");
        httpsListenerConnection.setAttribute("protocol", "HTTPS");
        if (httpsConnector != null && httpsListenerConnection.getChild("context", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE) == null) {
            Element tlsKeyStore;
            Element tlsContext = new Element("context", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
            boolean tlsConfigured = false;
            Element tlsServer = httpsConnector.getChild("tls-server", AbstractHttpConnectorMigrationStep.HTTPS_NAMESPACE);
            if (tlsServer != null) {
                Element trustStore = new Element("trust-store", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsServer, (Element)trustStore, (String)"path");
                if (tlsServer.getAttribute("class") != null) {
                    report.report("http.tlsServerClass", trustStore, tlsServer, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsServer, (Element)trustStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsServer, (Element)trustStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsServer, (Element)trustStore, (String)"algorithm");
                tlsContext.addContent((Content)trustStore);
                tlsConfigured = true;
            }
            if ((tlsKeyStore = httpsConnector.getChild("tls-key-store", AbstractHttpConnectorMigrationStep.HTTPS_NAMESPACE)) != null) {
                Element keyStore = new Element("key-store", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyPassword");
                if (tlsKeyStore.getAttribute("class") != null) {
                    report.report("http.tlsKeyStoreClass", tlsKeyStore, tlsKeyStore, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyAlias", (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if (tlsConfigured) {
                appModel.addNameSpace(AbstractHttpConnectorMigrationStep.TLS_NAMESPACE.getPrefix(), AbstractHttpConnectorMigrationStep.TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
                httpsListenerConnection.addContent((Content)tlsContext);
            }
        }
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector' and @name = '" + connectorName + "']");
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector']");
    }
}

