/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.properties;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.xpath.XPathFactory;

public class MuleAppProperties
implements NamespaceContribution {
    private static final String MULE_APP_FILE_NAME = "mule-app.properties";
    private static final String MULE_PROPS_FILE = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "mule-app.properties";

    public String getDescription() {
        return "Migrate mule-app.properties references on Config files.";
    }

    public void execute(ApplicationModel appModel, MigrationReport report) throws RuntimeException {
        try {
            List<String> properties = this.resolveProperties(appModel.getProjectBasePath(), MULE_PROPS_FILE);
            if (!properties.isEmpty()) {
                properties.forEach(p -> {
                    appModel.getDocumentsContainString("${" + p + "}").forEach(n -> this.addConfigFileReference((Document)n, appModel));
                    appModel.getDocumentsContainString("p(\\\"" + p + "\\\")").forEach(n -> this.addConfigFileReference((Document)n, appModel));
                    appModel.getDocumentsContainString("p('" + p + "')").forEach(n -> this.addConfigFileReference((Document)n, appModel));
                });
            }
        }
        catch (IOException e) {
            throw new MigrationStepException("Could not update mule-app.properties references on Files.", (Throwable)e);
        }
    }

    private void addConfigFileReference(Document document, ApplicationModel appModel) {
        Element configProperties = new Element("configuration-properties", XmlDslUtils.CORE_NAMESPACE);
        configProperties.setAttribute("file", MULE_APP_FILE_NAME);
        if (appModel.getElementsFromDocument(XPathFactory.instance().compile("//*[@file = 'mule-app.properties']"), document).isEmpty()) {
            XmlDslUtils.addTopLevelElement((Element)configProperties, (Document)document);
        }
    }

    private List<String> resolveProperties(Path filePath, String propsFileName) throws IOException {
        File muleAppProperties = new File(filePath.toFile(), propsFileName);
        ArrayList<String> appProperties = new ArrayList<String>();
        if (muleAppProperties != null && muleAppProperties.exists()) {
            try (FileInputStream inputStream = new FileInputStream(muleAppProperties);){
                Properties properties = new Properties();
                properties.load(inputStream);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> appProperties.add((String)k)));
            }
        }
        return appProperties;
    }
}

