/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractSalesforceConfigurationMigrationStep
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private final String name;
    protected ExpressionMigrator expressionMigrator;
    protected Element mule4Config;
    protected Element mule4Connection;
    private final String mule4Name;
    private static final String MULE4_PROXY = "proxy-configuration";

    public AbstractSalesforceConfigurationMigrationStep(String name, String mule4Name) {
        this.name = name;
        this.mule4Name = mule4Name;
    }

    public void execute(Element mule3Config, MigrationReport report) throws RuntimeException {
        ApplicationModel.addNameSpace((Namespace)SalesforceUtils.MULE4_SALESFORCE_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/salesforce/current/mule-salesforce.xsd", (Document)mule3Config.getDocument());
        this.mule4Config = new Element(this.getName(), SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
        this.setDefaultAttributes(mule3Config, this.mule4Config, report);
        this.setDefaultConnectionAttributes(mule3Config, this.mule4Config, this.mule4Name);
        Optional<Element> mule3ApexConfiguration = Optional.ofNullable(mule3Config.getChild("apex-class-names", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        mule3ApexConfiguration.ifPresent(apexClassNames -> {
            Element apexClassNameChild = apexClassNames.getChild("apex-class-name", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE);
            String apexClassNameValue = apexClassNameChild.getText();
            if (apexClassNameValue != null) {
                Element mule4ApexClassNames = new Element("apex-class-names", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
                Element mule4ApexClassNameChild = new Element("apex-class-name", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
                mule4ApexClassNameChild.setAttribute("value", apexClassNameValue);
                mule4ApexClassNames.addContent((Content)mule4ApexClassNameChild);
                this.mule4Config.addContent((Content)mule4ApexClassNames);
            }
        });
    }

    private void setDefaultAttributes(Element mule3Config, Element mule4Config, MigrationReport report) {
        String fetchAllApexRestMetadataValue;
        String fetchAllApexSoapMetadataValue;
        String docName;
        String nameValue = mule3Config.getAttributeValue("name");
        if (nameValue != null) {
            mule4Config.setAttribute("name", nameValue);
        }
        if ((docName = mule3Config.getAttributeValue("name", SalesforceUtils.DOC_NAMESPACE)) != null) {
            mule4Config.setAttribute("name", docName, SalesforceUtils.DOC_NAMESPACE);
        }
        if ((fetchAllApexSoapMetadataValue = mule3Config.getAttributeValue("fetchAllApexSoapMetadata")) != null) {
            mule4Config.setAttribute("fetchAllApexSoapMetadata", fetchAllApexSoapMetadataValue);
        }
        if ((fetchAllApexRestMetadataValue = mule3Config.getAttributeValue("fetchAllApexRestMetadata")) != null) {
            mule4Config.setAttribute("fetchAllApexRestMetadata", fetchAllApexRestMetadataValue);
        }
    }

    private void setDefaultConnectionAttributes(Element mule3Config, Element mule4Config, String mule4Name) {
        String principal;
        String storePassword;
        String keyStore;
        String apiVersion;
        String consumerSecret;
        String consumerKey;
        String clearNullFieldsValue;
        String useDefaultRuleValue;
        String allowFieldTruncationSupportValue;
        String serviceEndpointValue;
        String sessionIdValue;
        String timeObjectStoreValue;
        String clientIdValue;
        String assignmentRuleIdValue;
        String connectionTimeoutValue;
        String readTimeoutValue;
        String securityTokenValue;
        String passwordValue;
        this.mule4Connection = new Element(mule4Name, SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
        String usernameValue = mule3Config.getAttributeValue("username");
        if (usernameValue != null) {
            this.mule4Connection.setAttribute("username", usernameValue);
        }
        if ((passwordValue = mule3Config.getAttributeValue("password")) != null) {
            this.mule4Connection.setAttribute("password", passwordValue);
        }
        if ((securityTokenValue = mule3Config.getAttributeValue("securityToken")) != null) {
            this.mule4Connection.setAttribute("securityToken", securityTokenValue);
        }
        if ((readTimeoutValue = mule3Config.getAttributeValue("readTimeout")) != null) {
            this.mule4Connection.setAttribute("readTimeout", readTimeoutValue);
        }
        if ((connectionTimeoutValue = mule3Config.getAttributeValue("connectionTimeout")) != null) {
            this.mule4Connection.setAttribute("connectionTimeout", connectionTimeoutValue);
        }
        if ((assignmentRuleIdValue = mule3Config.getAttributeValue("assignmentRuleId")) != null) {
            this.mule4Connection.setAttribute("assignmentRuleId", assignmentRuleIdValue);
        }
        if ((clientIdValue = mule3Config.getAttributeValue("clientId")) != null) {
            this.mule4Connection.setAttribute("clientId", clientIdValue);
        }
        if ((timeObjectStoreValue = mule3Config.getAttributeValue("timeObjectStore-ref")) != null) {
            String expression = this.expressionMigrator.migrateExpression(timeObjectStoreValue, true, mule3Config);
            this.mule4Connection.setAttribute("timeObjectStore", expression);
        }
        if ((sessionIdValue = mule3Config.getAttributeValue("sessionId")) != null) {
            this.mule4Connection.setAttribute("sessionId", sessionIdValue);
        }
        if ((serviceEndpointValue = mule3Config.getAttributeValue("serviceEndpoint")) != null) {
            this.mule4Connection.setAttribute("serviceEndpoint", serviceEndpointValue);
        }
        if ((allowFieldTruncationSupportValue = mule3Config.getAttributeValue("allowFieldTruncationSupport")) != null) {
            this.mule4Connection.setAttribute("allowFieldTruncationSupport", allowFieldTruncationSupportValue);
        }
        if ((useDefaultRuleValue = mule3Config.getAttributeValue("useDefaultRule")) != null) {
            this.mule4Connection.setAttribute("useDefaultRule", useDefaultRuleValue);
        }
        if ((clearNullFieldsValue = mule3Config.getAttributeValue("clearNullFields")) != null) {
            this.mule4Connection.setAttribute("clearNullFields", clearNullFieldsValue);
        }
        if ((consumerKey = mule3Config.getAttributeValue("consumerKey")) != null) {
            this.mule4Connection.setAttribute("consumerKey", consumerKey);
        }
        if ((consumerSecret = mule3Config.getAttributeValue("consumerSecret")) != null) {
            this.mule4Connection.setAttribute("consumerSecret", consumerSecret);
        }
        if ((apiVersion = mule3Config.getAttributeValue("apiVersion")) != null) {
            this.mule4Connection.setAttribute("apiVersion", apiVersion);
        }
        if ((keyStore = mule3Config.getAttributeValue("keyStore")) != null) {
            this.mule4Connection.setAttribute("keyStore", keyStore);
        }
        if ((storePassword = mule3Config.getAttributeValue("storePassword")) != null) {
            this.mule4Connection.setAttribute("storePassword", storePassword);
        }
        if ((principal = mule3Config.getAttributeValue("principal")) != null) {
            this.mule4Connection.setAttribute("principal", principal);
        }
        this.setProxyConfiguration(mule3Config, this.mule4Connection);
        mule4Config.addContent((Content)this.mule4Connection);
    }

    private void setProxyConfiguration(Element mule3Config, Element mule4Connection) {
        String proxyHostValue = mule3Config.getAttributeValue("proxyHost");
        if (proxyHostValue != null && !proxyHostValue.isEmpty()) {
            Element mule4ProxyBasicConfig = new Element(MULE4_PROXY, SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
            mule4ProxyBasicConfig.setAttribute("host", proxyHostValue);
            mule4ProxyBasicConfig.setAttribute("username", mule3Config.getAttributeValue("proxyUsername"));
            mule4ProxyBasicConfig.setAttribute("password", mule3Config.getAttributeValue("proxyPassword"));
            mule4ProxyBasicConfig.setAttribute("port", mule3Config.getAttributeValue("proxyPort"));
            mule4Connection.addContent((Content)mule4ProxyBasicConfig);
        }
        Optional<Element> reconnectElement = Optional.ofNullable(mule3Config.getChild("reconnect", Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core")));
        Optional<Element> reconnectForeverElement = Optional.ofNullable(mule3Config.getChild("reconnect-forever", Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core")));
        if (reconnectElement.isPresent()) {
            this.migrateReconnection(mule4Connection, reconnectElement, "reconnect");
        } else if (reconnectForeverElement.isPresent()) {
            this.migrateReconnection(mule4Connection, reconnectForeverElement, "reconnect-forever");
        }
    }

    private void migrateReconnection(Element mule4Connection, Optional<Element> reconnectElement, String elementName) {
        reconnectElement.ifPresent(reconnect -> {
            String count;
            Element mule4Reconnection = new Element("reconnection");
            Element mule4Reconnect = new Element(elementName);
            String frequency = reconnect.getAttributeValue("frequency");
            if (frequency != null) {
                mule4Reconnect.setAttribute("frequency", frequency);
            }
            if ((count = reconnect.getAttributeValue("count")) != null) {
                mule4Reconnect.setAttribute("count", count);
            }
            mule4Reconnection.addContent((Content)mule4Reconnect);
            mule4Connection.addContent((Content)mule4Reconnection);
        });
    }

    public String getName() {
        return this.name;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

