/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AbstractSalesforceOperationMigrationStep
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private final String name;
    protected ExpressionMigrator expressionMigrator;
    protected Element mule4Operation;

    public AbstractSalesforceOperationMigrationStep(String name) {
        this.name = name;
    }

    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        ApplicationModel.addNameSpace((Namespace)SalesforceUtils.MULE4_SALESFORCE_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/salesforce/current/mule-salesforce.xsd", (Document)mule3Operation.getDocument());
        this.mule4Operation = new Element(this.getName(), SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
        this.setDefaultAttributes(mule3Operation, this.mule4Operation, report);
        this.migrateHeaders(mule3Operation, this.mule4Operation, report);
    }

    private void setDefaultAttributes(Element mule3Operation, Element mule4Operation, MigrationReport report) {
        String configRef;
        String notes;
        String docName = mule3Operation.getAttributeValue("name", SalesforceUtils.DOC_NAMESPACE);
        if (docName != null) {
            mule4Operation.setAttribute("name", docName, SalesforceUtils.DOC_NAMESPACE);
        }
        if ((notes = mule3Operation.getAttributeValue("description", SalesforceUtils.DOC_NAMESPACE)) != null) {
            mule4Operation.setAttribute("description", notes, SalesforceUtils.DOC_NAMESPACE);
        }
        if ((configRef = mule3Operation.getAttributeValue("config-ref")) != null && !configRef.isEmpty()) {
            mule4Operation.setAttribute("config-ref", configRef);
        }
        if (mule3Operation.getAttribute("accessTokenId") != null) {
            report.report("salesforce.accessTokenId", mule3Operation, mule4Operation, new String[0]);
        }
    }

    protected void migrateHeaders(Element mule3Operation, Element mule4Operation, MigrationReport report) {
        Optional<Element> mule3Headers = Optional.ofNullable(mule3Operation.getChild("headers", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        mule3Headers.ifPresent(headers -> {
            List children;
            String refHeaders = headers.getAttributeValue("ref");
            if (refHeaders != null) {
                String expression = this.expressionMigrator.migrateExpression(refHeaders, true, headers);
                mule4Operation.setAttribute("headers", expression);
            }
            if ((children = headers.getChildren()).size() > 0) {
                Element mule4Headers = new Element("headers", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
                children.forEach(header -> mule4Headers.addContent((Content)new Element("header", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE).setAttribute("key", header.getAttributeValue("key")).setAttribute("value", header.getText())));
                mule4Operation.addContent((Content)mule4Headers);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

