/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.crc32;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collections;
import java.util.Optional;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Crc32Calculate
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String CRC32_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/crc32";
    private static final Namespace CRC32_NAMESPACE = Namespace.getNamespace((String)"crc32", (String)"http://www.mulesoft.org/schema/mule/crc32");
    private static final Namespace CRYPTO_NAMESPACE = Namespace.getNamespace((String)"crypto", (String)"http://www.mulesoft.org/schema/mule/crypto");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/crc32' and local-name() = 'calculate']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update crc32 calculate to use the cryptography module.";
    }

    public Crc32Calculate() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(CRC32_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Crc32Calculate.addCryptoNamespace(element.getDocument());
        element.setName("calculateChecksum");
        element.setNamespace(CRYPTO_NAMESPACE);
        Optional config = this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/crc32' and local-name() = 'config']");
        element.removeAttribute("config-ref");
        element.setAttribute("algorithm", "CRC32");
        if (config.isPresent()) {
            element.setAttribute("target", this.getExpressionMigrator().migrateExpression(((Element)config.get()).getAttributeValue("targetExpression"), true, element, true));
        } else {
            element.setAttribute("target", "crc32");
        }
    }

    public static void addCryptoNamespace(Document document) {
        ApplicationModel.addNameSpace((Namespace)CRYPTO_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/crypto/current/mule-crypto.xsd", (Document)document);
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }
}

